/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history.useroperationlog;

import java.util.Date;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.history.UserOperationLogQuery;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.junit.Assert;
import org.junit.Test;

public class UserOperationLogJobDefinitionTest
extends AbstractUserOperationLogTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetOverridingPriority() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"JobDefinition", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertEquals((Object)"SetPriority", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"overridingPriority", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"42", (Object)userOperationLogEntry.getNewValue());
        Assert.assertEquals(null, (Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        Assert.assertEquals((Object)jobDefinition.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)jobDefinition.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)userOperationLogEntry.getDeploymentId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testOverwriteOverridingPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis()));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 43L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)((UserOperationLogQuery)this.historyService.createUserOperationLogQuery().orderByTimestamp().desc()).listPage(0, 1).get(0);
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"JobDefinition", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertEquals((Object)"SetPriority", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        Assert.assertEquals((Object)"overridingPriority", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"43", (Object)userOperationLogEntry.getNewValue());
        Assert.assertEquals((Object)"42", (Object)userOperationLogEntry.getOrgValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testClearOverridingPriority() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis()));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)((UserOperationLogQuery)this.historyService.createUserOperationLogQuery().orderByTimestamp().desc()).listPage(0, 1).get(0);
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"JobDefinition", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertEquals((Object)"SetPriority", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"overridingPriority", (Object)userOperationLogEntry.getProperty());
        Assert.assertNull((Object)userOperationLogEntry.getNewValue());
        Assert.assertEquals((Object)"42", (Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        Assert.assertEquals((Object)jobDefinition.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)jobDefinition.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)userOperationLogEntry.getDeploymentId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetOverridingPriorityCascadeToJobs() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L, true);
        Assert.assertEquals((long)3L, (long)this.historyService.createUserOperationLogQuery().count());
        UserOperationLogEntry processInstanceStartOpLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("ProcessInstance").singleResult();
        Assert.assertNotNull((Object)processInstanceStartOpLogEntry);
        UserOperationLogEntry jobDefOpLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("JobDefinition").singleResult();
        Assert.assertNotNull((Object)jobDefOpLogEntry);
        UserOperationLogEntry jobOpLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Job").singleResult();
        Assert.assertNotNull((Object)jobOpLogEntry);
        Assert.assertEquals((String)"the two job related entries should be part of the same operation", (Object)jobDefOpLogEntry.getOperationId(), (Object)jobOpLogEntry.getOperationId());
        Assert.assertEquals((Object)"Job", (Object)jobOpLogEntry.getEntityType());
        Assert.assertNull((String)"id should null because it is a bulk update operation", (Object)jobOpLogEntry.getJobId());
        Assert.assertEquals((Object)"SetPriority", (Object)jobOpLogEntry.getOperationType());
        Assert.assertEquals((Object)"priority", (Object)jobOpLogEntry.getProperty());
        Assert.assertEquals((Object)"42", (Object)jobOpLogEntry.getNewValue());
        Assert.assertNull((String)"Original Value should be null because it is not known for bulk operations", (Object)jobOpLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)jobOpLogEntry.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)jobOpLogEntry.getCategory());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)jobOpLogEntry.getJobDefinitionId());
        Assert.assertNull((String)"an unspecified set of process instances was affected by the operation", (Object)jobOpLogEntry.getProcessInstanceId());
        Assert.assertEquals((Object)job.getProcessDefinitionId(), (Object)jobOpLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)job.getProcessDefinitionKey(), (Object)jobOpLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)jobOpLogEntry.getDeploymentId());
    }
}

