/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history.useroperationlog;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.FormService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class UserOperationLogProcessInstanceTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected RuntimeService runtimeService;
    protected FormService formService;
    protected HistoryService historyService;

    @Before
    public void setup() {
        this.runtimeService = this.rule.getRuntimeService();
        this.formService = this.rule.getFormService();
        this.historyService = this.rule.getHistoryService();
        this.rule.getIdentityService().setAuthenticatedUserId("testUser");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldProduceUserOperationLogStartProcessInstanceByKey() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)userOperationLog.getOperationType()).isEqualTo((Object)"Create");
        Assertions.assertThat((String)userOperationLog.getProcessInstanceId()).isEqualTo((Object)instance.getId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldProduceUserOperationLogStartProcessInstanceById() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().singleResult();
        ProcessInstance instance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)userOperationLog.getOperationType()).isEqualTo((Object)"Create");
        Assertions.assertThat((String)userOperationLog.getProcessDefinitionId()).isEqualTo((Object)processDefinition.getId());
        Assertions.assertThat((String)userOperationLog.getProcessInstanceId()).isEqualTo((Object)instance.getId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldProduceUserOperationLogStartProcessInstanceAtActivity() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().singleResult();
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).startBeforeActivity("theTask")).execute();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)userOperationLog.getOperationType()).isEqualTo((Object)"Create");
        Assertions.assertThat((String)userOperationLog.getProcessDefinitionId()).isEqualTo((Object)processDefinition.getId());
        Assertions.assertThat((String)userOperationLog.getProcessInstanceId()).isEqualTo((Object)instance.getId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcessWithStartForm.bpmn20.xml"})
    public void shouldProduceUserOperationLogStartProcessInstanceBySubmitStartForm() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().singleResult();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("itemName", "apple");
        properties.put("amount", 5);
        ProcessInstance instance = this.formService.submitStartForm(processDefinition.getId(), properties);
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)userOperationLog.getOperationType()).isEqualTo((Object)"Create");
        Assertions.assertThat((String)userOperationLog.getProcessDefinitionId()).isEqualTo((Object)processDefinition.getId());
        Assertions.assertThat((String)userOperationLog.getProcessInstanceId()).isEqualTo((Object)instance.getId());
    }
}

