/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history.useroperationlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.history.UserOperationLogQuery;
import org.eximeebpms.bpm.engine.impl.RuntimeServiceImpl;
import org.eximeebpms.bpm.engine.impl.TaskServiceImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.task.Attachment;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class UserOperationLogQueryTest
extends AbstractUserOperationLogTest {
    protected static final String ONE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml";
    protected static final String ONE_TASK_CASE = "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String ONE_EXTERNAL_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml";
    private ProcessInstance process;
    private Task userTask;
    private Execution execution;
    private String processTaskId;
    private Date today = new Date(ClockUtil.getCurrentTime().getTime() / 1000L * 1000L);
    private Date tomorrow = new Date((ClockUtil.getCurrentTime().getTime() + 86400000L) / 1000L * 1000L);
    private Date yesterday = new Date((ClockUtil.getCurrentTime().getTime() - 86400000L) / 1000L * 1000L);

    @After
    public void tearDown() throws Exception {
        if (this.userTask != null) {
            this.historyService.deleteHistoricTaskInstance(this.userTask.getId());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQuery() {
        int i;
        int i2;
        this.createLogEntries();
        Assert.assertEquals((long)18L, (long)this.query().count());
        Assert.assertEquals((long)11L, (long)this.query().entityType("Task").count());
        Assert.assertEquals((long)4L, (long)this.query().entityType("IdentityLink").count());
        Assert.assertEquals((long)2L, (long)this.query().entityType("Attachment").count());
        Assert.assertEquals((long)1L, (long)this.query().entityType("ProcessInstance").count());
        Assert.assertEquals((long)0L, (long)this.query().entityType("unknown entity type").count());
        Assert.assertEquals((long)2L, (long)this.query().operationType("Create").count());
        Assert.assertEquals((long)1L, (long)this.query().operationType("SetPriority").count());
        Assert.assertEquals((long)4L, (long)this.query().operationType("Update").count());
        Assert.assertEquals((long)1L, (long)this.query().operationType("AddUserLink").count());
        Assert.assertEquals((long)1L, (long)this.query().operationType("DeleteUserLink").count());
        Assert.assertEquals((long)1L, (long)this.query().operationType("AddGroupLink").count());
        Assert.assertEquals((long)1L, (long)this.query().operationType("DeleteGroupLink").count());
        Assert.assertEquals((long)1L, (long)this.query().operationType("AddAttachment").count());
        Assert.assertEquals((long)1L, (long)this.query().operationType("DeleteAttachment").count());
        Assert.assertEquals((long)17L, (long)this.query().categoryIn(new String[]{"TaskWorker"}).count());
        Assert.assertEquals((long)1L, (long)this.query().categoryIn(new String[]{"Operator"}).count());
        Assert.assertEquals((long)12L, (long)this.query().processDefinitionId(this.process.getProcessDefinitionId()).count());
        Assert.assertEquals((long)12L, (long)this.query().processInstanceId(this.process.getId()).count());
        Assert.assertEquals((long)11L, (long)this.query().executionId(this.execution.getId()).count());
        Assert.assertEquals((long)11L, (long)this.query().taskId(this.processTaskId).count());
        Assert.assertEquals((long)6L, (long)this.query().taskId(this.userTask.getId()).count());
        Assert.assertEquals((long)11L, (long)this.query().userId("icke").count());
        Assert.assertEquals((long)6L, (long)this.query().userId("er").count());
        UserOperationLogQuery updates = this.query().operationType("Update");
        String updateOperationId = ((UserOperationLogEntry)updates.list().get(0)).getOperationId();
        Assert.assertEquals((long)updates.count(), (long)this.query().operationId(updateOperationId).count());
        Assert.assertEquals((long)3L, (long)this.query().property("assignee").count());
        Assert.assertEquals((long)2L, (long)this.query().property("owner").count());
        List ascLog = ((UserOperationLogQuery)this.query().orderByTimestamp().asc()).list();
        for (i2 = 0; i2 < 5; ++i2) {
            Assert.assertTrue((this.yesterday.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i2 = 5; i2 < 13; ++i2) {
            Assert.assertTrue((this.today.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i2 = 13; i2 < 18; ++i2) {
            Assert.assertTrue((this.tomorrow.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        List descLog = ((UserOperationLogQuery)this.query().orderByTimestamp().desc()).list();
        for (i = 0; i < 4; ++i) {
            Assert.assertTrue((this.tomorrow.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i = 4; i < 11; ++i) {
            Assert.assertTrue((this.today.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i = 11; i < 18; ++i) {
            Assert.assertTrue((this.yesterday.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)5L, (long)this.query().beforeTimestamp(this.today).count());
        Assert.assertEquals((long)13L, (long)this.query().beforeTimestamp(this.tomorrow).count());
        Assert.assertEquals((long)13L, (long)this.query().afterTimestamp(this.yesterday).count());
        Assert.assertEquals((long)5L, (long)this.query().afterTimestamp(this.today).count());
        Assert.assertEquals((long)0L, (long)this.query().afterTimestamp(this.today).beforeTimestamp(this.yesterday).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryWithBackwardCompatibility() {
        this.createLogEntries();
        Assert.assertEquals((long)18L, (long)this.query().count());
        Assert.assertEquals((long)11L, (long)this.query().entityType("Task").count());
        Assert.assertEquals((long)4L, (long)this.query().entityType("IdentityLink").count());
        Assert.assertEquals((long)2L, (long)this.query().entityType("Attachment").count());
        Assert.assertEquals((long)0L, (long)this.query().entityType("unknown entity type").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessInstanceOperationsById() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceById(this.process.getId());
        this.runtimeService.activateProcessInstanceById(this.process.getId());
        this.runtimeService.deleteProcessInstance(this.process.getId(), "a delete reason");
        Assert.assertEquals((long)4L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry deleteEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Delete").singleResult();
        Assert.assertNotNull((Object)deleteEntry);
        Assert.assertEquals((Object)this.process.getId(), (Object)deleteEntry.getProcessInstanceId());
        Assert.assertNotNull((Object)deleteEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)deleteEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)deleteEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)deleteEntry.getCategory());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Suspend").singleResult();
        Assert.assertNotNull((Object)suspendEntry);
        Assert.assertEquals((Object)this.process.getId(), (Object)suspendEntry.getProcessInstanceId());
        Assert.assertNotNull((Object)suspendEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendEntry.getNewValue());
        Assert.assertNull((Object)suspendEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendEntry.getCategory());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Activate").singleResult();
        Assert.assertNotNull((Object)activateEntry);
        Assert.assertEquals((Object)this.process.getId(), (Object)activateEntry.getProcessInstanceId());
        Assert.assertNotNull((Object)activateEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activateEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)activateEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)activateEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateEntry.getNewValue());
        Assert.assertNull((Object)activateEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activateEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessInstanceOperationsByProcessDefinitionId() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(this.process.getProcessDefinitionId());
        Assert.assertEquals((long)3L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionId(this.process.getProcessDefinitionId()).operationType("Suspend").singleResult();
        Assert.assertNotNull((Object)suspendEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)suspendEntry.getProcessDefinitionId());
        Assert.assertNull((Object)suspendEntry.getProcessInstanceId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)suspendEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendEntry.getNewValue());
        Assert.assertNull((Object)suspendEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendEntry.getCategory());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionId(this.process.getProcessDefinitionId()).operationType("Activate").singleResult();
        Assert.assertNotNull((Object)activateEntry);
        Assert.assertNull((Object)activateEntry.getProcessInstanceId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activateEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)activateEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)deploymentId, (Object)activateEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)activateEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateEntry.getNewValue());
        Assert.assertNull((Object)activateEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activateEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessInstanceOperationsByProcessDefinitionKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        Assert.assertEquals((long)3L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionKey("oneTaskProcess").operationType("Suspend").singleResult();
        Assert.assertNotNull((Object)suspendEntry);
        Assert.assertNull((Object)suspendEntry.getProcessInstanceId());
        Assert.assertNull((Object)suspendEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)suspendEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendEntry.getNewValue());
        Assert.assertNull((Object)suspendEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendEntry.getCategory());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionKey("oneTaskProcess").operationType("Activate").singleResult();
        Assert.assertNotNull((Object)activateEntry);
        Assert.assertNull((Object)activateEntry.getProcessInstanceId());
        Assert.assertNull((Object)activateEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activateEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)activateEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)activateEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateEntry.getNewValue());
        Assert.assertNull((Object)activateEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activateEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessDefinitionOperationsById() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        this.repositoryService.activateProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").property("suspensionState").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("SuspendProcessDefinition").property("suspensionState").singleResult();
        Assert.assertNotNull((Object)suspendDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)suspendDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendDefinitionEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)suspendDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendDefinitionEntry.getCategory());
        UserOperationLogEntry activateDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("ActivateProcessDefinition").property("suspensionState").singleResult();
        Assert.assertNotNull((Object)activateDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)activateDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activateDefinitionEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)activateDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)activateDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activateDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activateDefinitionEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessDefinitionOperationsByKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess", true, null);
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").property("suspensionState").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("SuspendProcessDefinition").property("suspensionState").singleResult();
        Assert.assertNotNull((Object)suspendDefinitionEntry);
        Assert.assertNull((Object)suspendDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)suspendDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendDefinitionEntry.getCategory());
        UserOperationLogEntry activateDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("ActivateProcessDefinition").property("suspensionState").singleResult();
        Assert.assertNotNull((Object)activateDefinitionEntry);
        Assert.assertNull((Object)activateDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activateDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)activateDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)activateDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activateDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activateDefinitionEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessDefinitionOperationsById_createsTwoLogEntries() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        this.repositoryService.activateProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").operationType("SuspendProcessDefinition").count());
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").operationType("ActivateProcessDefinition").count());
        Set actualProperties = this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("SuspendProcessDefinition").list().stream().map(UserOperationLogEntry::getProperty).collect(Collectors.toSet());
        Assert.assertEquals(actualProperties, new HashSet<String>(Arrays.asList("includeProcessInstances", "suspensionState")));
        actualProperties = this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("ActivateProcessDefinition").list().stream().map(UserOperationLogEntry::getProperty).collect(Collectors.toSet());
        Assert.assertEquals(actualProperties, new HashSet<String>(Arrays.asList("includeProcessInstances", "suspensionState")));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessDefinitionOperationsById_includeProcessInstancesEntries() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        this.repositoryService.activateProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").property("includeProcessInstances").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("SuspendProcessDefinition").property("includeProcessInstances").singleResult();
        Assert.assertNotNull((Object)suspendDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)suspendDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendDefinitionEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)suspendDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"includeProcessInstances", (Object)suspendDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"true", (Object)suspendDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendDefinitionEntry.getCategory());
        UserOperationLogEntry activeDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("ActivateProcessDefinition").property("includeProcessInstances").singleResult();
        Assert.assertNotNull((Object)activeDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)activeDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activeDefinitionEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)activeDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"includeProcessInstances", (Object)activeDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"true", (Object)activeDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activeDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activeDefinitionEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessDefinitionOperationsById_excludeProcessInstancesEntries() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionById(this.process.getProcessDefinitionId(), false, null);
        this.repositoryService.activateProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").property("includeProcessInstances").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("SuspendProcessDefinition").property("includeProcessInstances").singleResult();
        Assert.assertNotNull((Object)suspendDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)suspendDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendDefinitionEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)suspendDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"includeProcessInstances", (Object)suspendDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"false", (Object)suspendDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendDefinitionEntry.getCategory());
        UserOperationLogEntry activeDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("ActivateProcessDefinition").property("includeProcessInstances").singleResult();
        Assert.assertNotNull((Object)activeDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)activeDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activeDefinitionEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)activeDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"includeProcessInstances", (Object)activeDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"true", (Object)activeDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activeDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activeDefinitionEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessDefinitionOperationsByKey_createsTwoLogEntries() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess", true, null);
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").operationType("SuspendProcessDefinition").count());
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").operationType("ActivateProcessDefinition").count());
        Set actualProperties = this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("SuspendProcessDefinition").list().stream().map(UserOperationLogEntry::getProperty).collect(Collectors.toSet());
        Assert.assertEquals(actualProperties, new HashSet<String>(Arrays.asList("includeProcessInstances", "suspensionState")));
        actualProperties = this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("ActivateProcessDefinition").list().stream().map(UserOperationLogEntry::getProperty).collect(Collectors.toSet());
        Assert.assertEquals(actualProperties, new HashSet<String>(Arrays.asList("includeProcessInstances", "suspensionState")));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessDefinitionOperationsByKey_includeProcessInstancesEntries() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess", true, null);
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").property("includeProcessInstances").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("SuspendProcessDefinition").property("includeProcessInstances").singleResult();
        Assert.assertNotNull((Object)suspendDefinitionEntry);
        Assert.assertNull((Object)suspendDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)suspendDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"includeProcessInstances", (Object)suspendDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"true", (Object)suspendDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendDefinitionEntry.getCategory());
        UserOperationLogEntry activeDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("ActivateProcessDefinition").property("includeProcessInstances").singleResult();
        Assert.assertNotNull((Object)activeDefinitionEntry);
        Assert.assertNull((Object)activeDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activeDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)activeDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"includeProcessInstances", (Object)activeDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"true", (Object)activeDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activeDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activeDefinitionEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessDefinitionOperationsByKey_excludeProcessInstancesEntries() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", false, null);
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess", false, null);
        Assert.assertEquals((long)2L, (long)this.query().entityType("ProcessDefinition").property("includeProcessInstances").count());
        UserOperationLogEntry suspendDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("SuspendProcessDefinition").property("includeProcessInstances").singleResult();
        Assert.assertNotNull((Object)suspendDefinitionEntry);
        Assert.assertNull((Object)suspendDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)suspendDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)suspendDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"includeProcessInstances", (Object)suspendDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"false", (Object)suspendDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendDefinitionEntry.getCategory());
        UserOperationLogEntry activeDefinitionEntry = (UserOperationLogEntry)this.query().entityType("ProcessDefinition").processDefinitionKey("oneTaskProcess").operationType("ActivateProcessDefinition").property("includeProcessInstances").singleResult();
        Assert.assertNotNull((Object)activeDefinitionEntry);
        Assert.assertNull((Object)activeDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneTaskProcess", (Object)activeDefinitionEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)activeDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"includeProcessInstances", (Object)activeDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"false", (Object)activeDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activeDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activeDefinitionEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryJobOperations() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.process = this.runtimeService.startProcessInstanceByKey("process");
        this.managementService.suspendJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.activateJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.suspendJobByProcessInstanceId(this.process.getId());
        this.managementService.activateJobByProcessInstanceId(this.process.getId());
        Assert.assertEquals((long)2L, (long)this.query().entityType("JobDefinition").count());
        Assert.assertEquals((long)2L, (long)this.query().entityType("Job").count());
        UserOperationLogEntry activeJobDefinitionEntry = (UserOperationLogEntry)this.query().entityType("JobDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("ActivateJobDefinition").singleResult();
        Assert.assertNotNull((Object)activeJobDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)activeJobDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)deploymentId, (Object)activeJobDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)activeJobDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activeJobDefinitionEntry.getNewValue());
        Assert.assertNull((Object)activeJobDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activeJobDefinitionEntry.getCategory());
        UserOperationLogEntry activateJobIdEntry = (UserOperationLogEntry)this.query().entityType("Job").processInstanceId(this.process.getProcessInstanceId()).operationType("ActivateJob").singleResult();
        Assert.assertNotNull((Object)activateJobIdEntry);
        Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)activateJobIdEntry.getProcessInstanceId());
        Assert.assertEquals((Object)deploymentId, (Object)activateJobIdEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)activateJobIdEntry.getProperty());
        Assert.assertEquals((Object)"active", (Object)activateJobIdEntry.getNewValue());
        Assert.assertNull((Object)activateJobIdEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)activateJobIdEntry.getCategory());
        UserOperationLogEntry suspendJobDefinitionEntry = (UserOperationLogEntry)this.query().entityType("JobDefinition").processDefinitionId(this.process.getProcessDefinitionId()).operationType("SuspendJobDefinition").singleResult();
        Assert.assertNotNull((Object)suspendJobDefinitionEntry);
        Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)suspendJobDefinitionEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)deploymentId, (Object)suspendJobDefinitionEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendJobDefinitionEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendJobDefinitionEntry.getNewValue());
        Assert.assertNull((Object)suspendJobDefinitionEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendJobDefinitionEntry.getCategory());
        UserOperationLogEntry suspendedJobEntry = (UserOperationLogEntry)this.query().entityType("Job").processInstanceId(this.process.getProcessInstanceId()).operationType("SuspendJob").singleResult();
        Assert.assertNotNull((Object)suspendedJobEntry);
        Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)suspendedJobEntry.getProcessInstanceId());
        Assert.assertEquals((Object)deploymentId, (Object)suspendedJobEntry.getDeploymentId());
        Assert.assertEquals((Object)"suspensionState", (Object)suspendedJobEntry.getProperty());
        Assert.assertEquals((Object)"suspended", (Object)suspendedJobEntry.getNewValue());
        Assert.assertNull((Object)suspendedJobEntry.getOrgValue());
        Assert.assertEquals((Object)"Operator", (Object)suspendedJobEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    @Test
    public void testQueryJobRetryOperationsById() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.process = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(this.process.getProcessInstanceId()).singleResult();
        this.managementService.setJobRetries(job.getId(), 10);
        Assert.assertEquals((long)1L, (long)this.query().entityType("Job").operationType("SetJobRetries").count());
        UserOperationLogEntry jobRetryEntry = (UserOperationLogEntry)this.query().entityType("Job").jobId(job.getId()).operationType("SetJobRetries").singleResult();
        Assert.assertNotNull((Object)jobRetryEntry);
        Assert.assertEquals((Object)job.getId(), (Object)jobRetryEntry.getJobId());
        Assert.assertEquals((Object)"3", (Object)jobRetryEntry.getOrgValue());
        Assert.assertEquals((Object)"10", (Object)jobRetryEntry.getNewValue());
        Assert.assertEquals((Object)"retries", (Object)jobRetryEntry.getProperty());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)jobRetryEntry.getJobDefinitionId());
        Assert.assertEquals((Object)job.getProcessInstanceId(), (Object)jobRetryEntry.getProcessInstanceId());
        Assert.assertEquals((Object)job.getProcessDefinitionKey(), (Object)jobRetryEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)job.getProcessDefinitionId(), (Object)jobRetryEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)deploymentId, (Object)jobRetryEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)jobRetryEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryJobDefinitionOperationWithDelayedJobDefinition() {
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processDefinitionId = process.getProcessDefinitionId();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        ClockUtil.setCurrentTime((Date)this.today);
        long oneWeekFromStartTime = this.today.getTime() + 604800000L;
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, false, new Date(oneWeekFromStartTime));
        Long jobDefinitionEntryCount = this.query().entityType("JobDefinition").operationType("ActivateJobDefinition").processDefinitionId(processDefinitionId).category("Operator").count();
        Assert.assertEquals((long)1L, (long)jobDefinitionEntryCount);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        jobDefinitionEntryCount = this.query().entityType("JobDefinition").operationType("ActivateJobDefinition").processDefinitionId(processDefinitionId).category("Operator").count();
        Assert.assertEquals((long)1L, (long)jobDefinitionEntryCount);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-job-definition");
                return null;
            }
        });
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    @Test
    public void testQueryProcessDefinitionOperationWithDelayedProcessDefinition() {
        ClockUtil.setCurrentTime((Date)this.today);
        long hourInMs = 3600000L;
        String key = "oneFailingServiceTaskProcess";
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey(key, params);
        this.repositoryService.suspendProcessDefinitionByKey(key, false, new Date(this.today.getTime() + 0x6DDD00L));
        Job timerToSuspendProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        Assert.assertNotNull((Object)timerToSuspendProcessDefinition);
        Long processDefinitionEntryCount = this.query().entityType("ProcessDefinition").operationType("SuspendProcessDefinition").processDefinitionKey(key).category("Operator").property("suspensionState").count();
        Assert.assertEquals((long)1L, (long)processDefinitionEntryCount);
        this.managementService.executeJob(timerToSuspendProcessDefinition.getId());
        processDefinitionEntryCount = this.query().entityType("ProcessDefinition").operationType("SuspendProcessDefinition").processDefinitionKey(key).category("Operator").property("suspensionState").count();
        Assert.assertEquals((long)1L, (long)processDefinitionEntryCount);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                return null;
            }
        });
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryProcessInstanceModificationOperation() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
        UserOperationLogQuery logQuery = this.query().entityType("ProcessInstance").operationType("ModifyProcessInstance");
        Assert.assertEquals((long)1L, (long)logQuery.count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)logEntry.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)logEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)definition.getKey(), (Object)logEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)deploymentId, (Object)logEntry.getDeploymentId());
        Assert.assertEquals((Object)"ModifyProcessInstance", (Object)logEntry.getOperationType());
        Assert.assertEquals((Object)"ProcessInstance", (Object)logEntry.getEntityType());
        Assert.assertNull((Object)logEntry.getProperty());
        Assert.assertNull((Object)logEntry.getOrgValue());
        Assert.assertNull((Object)logEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)logEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryAddExecutionVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable1", (Object)"THIS IS TESTVARIABLE!!!");
        this.verifyVariableOperationAsserts(1, "SetVariable", "Operator");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryAddExecutionVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(this.process.getId(), this.createMapForVariableAddition());
        this.verifyVariableOperationAsserts(1, "SetVariable", "Operator");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryAddExecutionVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable3", (Object)"foo");
        this.runtimeService.setVariables(this.process.getId(), this.createMapForVariableAddition());
        this.runtimeService.setVariable(this.process.getId(), "testVariable4", (Object)"bar");
        this.verifyVariableOperationAsserts(3, "SetVariable", "Operator");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryAddTaskVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable1", (Object)"THIS IS TESTVARIABLE!!!");
        this.verifyVariableOperationAsserts(1, "SetVariable", "TaskWorker");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryAddTaskVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariables(this.processTaskId, this.createMapForVariableAddition());
        this.verifyVariableOperationAsserts(1, "SetVariable", "TaskWorker");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryAddTaskVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable3", (Object)"foo");
        this.taskService.setVariables(this.processTaskId, this.createMapForVariableAddition());
        this.taskService.setVariable(this.processTaskId, "testVariable4", (Object)"bar");
        this.verifyVariableOperationAsserts(3, "SetVariable", "TaskWorker");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryPatchExecutionVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(this.process.getId(), this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "ModifyVariable", "Operator");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryPatchTaskVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(this.processTaskId, this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "ModifyVariable", "TaskWorker");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryRemoveExecutionVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariable(this.process.getId(), "testVariable1");
        this.verifyVariableOperationAsserts(1, "RemoveVariable", "Operator");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryRemoveExecutionVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariables(this.process.getId(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "RemoveVariable", "Operator");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryRemoveExecutionVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariable(this.process.getId(), "testVariable1");
        this.runtimeService.removeVariables(this.process.getId(), this.createCollectionForVariableDeletion());
        this.runtimeService.removeVariable(this.process.getId(), "testVariable2");
        this.verifyVariableOperationAsserts(3, "RemoveVariable", "Operator");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryRemoveTaskVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.removeVariable(this.processTaskId, "testVariable1");
        this.verifyVariableOperationAsserts(1, "RemoveVariable", "TaskWorker");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryRemoveTaskVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.removeVariables(this.processTaskId, this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts(1, "RemoveVariable", "TaskWorker");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryRemoveTaskVariablesSingleAndMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.removeVariable(this.processTaskId, "testVariable3");
        this.taskService.removeVariables(this.processTaskId, this.createCollectionForVariableDeletion());
        this.taskService.removeVariable(this.processTaskId, "testVariable4");
        this.verifyVariableOperationAsserts(3, "RemoveVariable", "TaskWorker");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByEntityTypes() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(this.processTaskId, "foo");
        this.taskService.setVariable(this.processTaskId, "foo", (Object)"bar");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().entityTypeIn(new String[]{"Task", "Variable"});
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByInvalidEntityTypes() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().entityTypeIn(new String[]{"foo"});
        this.verifyQueryResults(query, 0);
        try {
            query.entityTypeIn((String[])null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.entityTypeIn(new String[]{"Task", null, "Variable"});
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByCategories() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(this.processTaskId, "foo");
        this.taskService.setVariable(this.processTaskId, "foo", (Object)"bar");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().categoryIn(new String[]{"TaskWorker", "Operator"});
        this.verifyQueryResults(query, 3);
        query = this.historyService.createUserOperationLogQuery().categoryIn(new String[]{"TaskWorker"});
        this.verifyQueryResults(query, 2);
        query = this.historyService.createUserOperationLogQuery().category("Operator");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCategories() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().categoryIn(new String[]{"foo"});
        this.verifyQueryResults(query, 0);
        query = this.historyService.createUserOperationLogQuery().category("foo");
        this.verifyQueryResults(query, 0);
        try {
            query.category(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.categoryIn((String[])null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.categoryIn(new String[]{"Admin", null, "TaskWorker"});
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDeleteVariableHistoryOperationOnRunningInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test2");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyHistoricVariableOperationAsserts(1, "DeleteHistory");
        this.verifySingleVariableOperationPropertyChange("name", "testVariable", "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDeleteVariableHistoryOperationOnHistoricInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.deleteProcessInstance(this.process.getId(), "none");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyHistoricVariableOperationAsserts(1, "DeleteHistory");
        this.verifySingleVariableOperationPropertyChange("name", "testVariable", "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDeleteVariableHistoryOperationOnTaskOfRunningInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable", (Object)"test");
        this.taskService.setVariable(this.processTaskId, "testVariable", (Object)"test2");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyHistoricVariableOperationAsserts(1, "DeleteHistory");
        this.verifySingleVariableOperationPropertyChange("name", "testVariable", "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDeleteVariableHistoryOperationOnTaskOfHistoricInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable", (Object)"test");
        this.runtimeService.deleteProcessInstance(this.process.getId(), "none");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyHistoricVariableOperationAsserts(1, "DeleteHistory");
        this.verifySingleVariableOperationPropertyChange("name", "testVariable", "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryDeleteVariableHistoryOperationOnCase() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)1);
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)2);
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)3);
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        this.verfiySingleCaseVariableOperationAsserts(caseInstance);
        this.verifySingleVariableOperationPropertyChange("name", "myVariable", "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryDeleteVariableHistoryOperationOnTaskOfCase() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "myVariable", (Object)"1");
        this.taskService.setVariable(this.processTaskId, "myVariable", (Object)"2");
        this.taskService.setVariable(this.processTaskId, "myVariable", (Object)"3");
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        this.verfiySingleCaseVariableOperationAsserts(caseInstance);
        this.verifySingleVariableOperationPropertyChange("name", "myVariable", "DeleteHistory");
    }

    @Test
    public void testQueryDeleteVariableHistoryOperationOnStandaloneTask() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue");
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue2");
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        String operationType = "DeleteHistory";
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        Assert.assertEquals((long)1L, (long)logQuery.count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
        Assert.assertEquals((Object)task.getId(), (Object)logEntry.getTaskId());
        Assert.assertNull((Object)logEntry.getDeploymentId());
        this.verifySingleVariableOperationPropertyChange("name", "testVariable", "DeleteHistory");
        this.taskService.deleteTask(task.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDeleteVariablesHistoryOperationOnRunningInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test2");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test2");
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(this.process.getId());
        this.verifyHistoricVariableOperationAsserts(1, "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDeleteVariablesHistoryOperationOnHistoryInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test");
        this.runtimeService.deleteProcessInstance(this.process.getId(), "none");
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(this.process.getId());
        this.verifyHistoricVariableOperationAsserts(1, "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDeleteVariableAndVariablesHistoryOperationOnRunningInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test2");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test2");
        this.runtimeService.setVariable(this.process.getId(), "testVariable3", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable3", (Object)"test2");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("testVariable").singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(this.process.getId());
        this.verifyHistoricVariableOperationAsserts(2, "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDeleteVariableAndVariablesHistoryOperationOnHistoryInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable3", (Object)"test");
        this.runtimeService.deleteProcessInstance(this.process.getId(), "none");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("testVariable").singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(this.process.getId());
        this.verifyHistoricVariableOperationAsserts(2, "DeleteHistory");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseDefinitionId(caseDefinitionId).category("TaskWorker");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseInstanceId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseInstanceId(caseInstanceId).category("TaskWorker");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseExecutionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseExecutionId(caseExecutionId).category("TaskWorker");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByExternalTaskId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.externalTaskService.setRetries(task.getId(), 5);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().externalTaskId(task.getId());
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDeploymentId() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(ONE_TASK_PROCESS).deploy().getId();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().deploymentId(deploymentId).category("Operator");
        this.verifyQueryResults(query, 1);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Test
    public void testQueryByInvalidDeploymentId() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.deploymentId(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private void verifyQueryResults(UserOperationLogQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(UserOperationLogQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private Map<String, Object> createMapForVariableAddition() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("testVariable1", "THIS IS TESTVARIABLE!!!");
        variables.put("testVariable2", "OVER 9000!");
        return variables;
    }

    private Collection<String> createCollectionForVariableDeletion() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("testVariable3");
        variables.add("testVariable4");
        return variables;
    }

    private void verifyVariableOperationAsserts(int countAssertValue, String operationType, String category) {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        Assert.assertEquals((long)countAssertValue, (long)logQuery.count());
        if (countAssertValue > 1) {
            List logEntryList = logQuery.list();
            for (UserOperationLogEntry logEntry : logEntryList) {
                Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)logEntry.getProcessDefinitionId());
                Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)logEntry.getProcessInstanceId());
                Assert.assertEquals((Object)deploymentId, (Object)logEntry.getDeploymentId());
                Assert.assertEquals((Object)category, (Object)logEntry.getCategory());
            }
        } else {
            UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
            Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)logEntry.getProcessDefinitionId());
            Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)logEntry.getProcessInstanceId());
            Assert.assertEquals((Object)deploymentId, (Object)logEntry.getDeploymentId());
            Assert.assertEquals((Object)category, (Object)logEntry.getCategory());
        }
    }

    private void verifyHistoricVariableOperationAsserts(int countAssertValue, String operationType) {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        Assert.assertEquals((long)countAssertValue, (long)logQuery.count());
        if (countAssertValue > 1) {
            List logEntryList = logQuery.list();
            for (UserOperationLogEntry logEntry : logEntryList) {
                Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)logEntry.getProcessDefinitionId());
                Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)logEntry.getProcessInstanceId());
                Assert.assertEquals((Object)deploymentId, (Object)logEntry.getDeploymentId());
                Assert.assertNull((Object)logEntry.getTaskId());
                Assert.assertEquals((Object)"Operator", (Object)logEntry.getCategory());
            }
        } else {
            UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
            Assert.assertEquals((Object)this.process.getProcessDefinitionId(), (Object)logEntry.getProcessDefinitionId());
            Assert.assertEquals((Object)this.process.getProcessInstanceId(), (Object)logEntry.getProcessInstanceId());
            Assert.assertEquals((Object)deploymentId, (Object)logEntry.getDeploymentId());
            Assert.assertNull((Object)logEntry.getTaskId());
            Assert.assertEquals((Object)"Operator", (Object)logEntry.getCategory());
        }
    }

    private void verifySingleVariableOperationPropertyChange(String property, String newValue, String operationType) {
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        Assert.assertEquals((long)1L, (long)logQuery.count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
        Assert.assertEquals((Object)property, (Object)logEntry.getProperty());
        Assert.assertEquals((Object)newValue, (Object)logEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)logEntry.getCategory());
    }

    private void verfiySingleCaseVariableOperationAsserts(CaseInstance caseInstance) {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String operationType = "DeleteHistory";
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        Assert.assertEquals((long)1L, (long)logQuery.count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)logQuery.singleResult();
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)logEntry.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)logEntry.getCaseInstanceId());
        Assert.assertEquals((Object)deploymentId, (Object)logEntry.getDeploymentId());
        Assert.assertNull((Object)logEntry.getTaskId());
        Assert.assertEquals((Object)"Operator", (Object)logEntry.getCategory());
    }

    private UserOperationLogQuery query() {
        return this.historyService.createUserOperationLogQuery();
    }

    private void createLogEntries() {
        ClockUtil.setCurrentTime((Date)this.yesterday);
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.execution = (Execution)this.processEngine.getRuntimeService().createExecutionQuery().processInstanceId(this.process.getId()).singleResult();
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("icke");
        this.taskService.addCandidateUser(this.processTaskId, "er");
        this.taskService.deleteCandidateUser(this.processTaskId, "er");
        this.taskService.addCandidateGroup(this.processTaskId, "wir");
        this.taskService.deleteCandidateGroup(this.processTaskId, "wir");
        ClockUtil.setCurrentTime((Date)this.today);
        this.taskService.setOwner(this.processTaskId, "icke");
        this.taskService.claim(this.processTaskId, "icke");
        this.taskService.setAssignee(this.processTaskId, "er");
        this.taskService.setPriority(this.processTaskId, 10);
        Attachment attachment = this.taskService.createAttachment("image/ico", this.processTaskId, this.process.getId(), "favicon.ico", "favicon", "http://eximeebpms.com/favicon.ico");
        this.taskService.deleteAttachment(attachment.getId());
        this.taskService.complete(this.processTaskId);
        this.testRule.assertProcessEnded(this.process.getId());
        this.identityService.setAuthenticatedUserId("er");
        this.userTask = this.taskService.newTask();
        this.userTask.setName("to do");
        this.taskService.saveTask(this.userTask);
        ClockUtil.setCurrentTime((Date)this.tomorrow);
        this.userTask.setDescription("desc");
        this.userTask.setOwner("icke");
        this.userTask.setAssignee("er");
        this.userTask.setDueDate(new Date());
        this.taskService.saveTask(this.userTask);
        this.taskService.complete(this.userTask.getId());
    }
}

