/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.Date;
import org.eximeebpms.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class AcquireJobsCmdTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/standalone/jobexecutor/oneJobProcess.bpmn20.xml"})
    @Test
    public void testJobsNotVisisbleToAcquisitionIfInstanceSuspended() {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(pd.getKey());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.makeSureJobDue(job);
        AcquiredJobs acquiredJobs = this.executeAcquireJobsCommand();
        Assert.assertEquals((long)1L, (long)acquiredJobs.size());
        this.runtimeService.suspendProcessInstanceById(pi.getId());
        acquiredJobs = this.executeAcquireJobsCommand();
        Assert.assertEquals((long)0L, (long)acquiredJobs.size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/standalone/jobexecutor/oneJobProcess.bpmn20.xml"})
    @Test
    public void testJobsNotVisisbleToAcquisitionIfDefinitionSuspended() {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(pd.getKey());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.makeSureJobDue(job);
        AcquiredJobs acquiredJobs = this.executeAcquireJobsCommand();
        Assert.assertEquals((long)1L, (long)acquiredJobs.size());
        this.repositoryService.suspendProcessDefinitionById(pd.getId());
        acquiredJobs = this.executeAcquireJobsCommand();
        Assert.assertEquals((long)0L, (long)acquiredJobs.size());
    }

    protected void makeSureJobDue(final Job job) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                Date currentTime = ClockUtil.getCurrentTime();
                commandContext.getJobManager().findJobById(job.getId()).setDuedate(new Date(currentTime.getTime() - 10000L));
                return null;
            }
        });
    }

    private AcquiredJobs executeAcquireJobsCommand() {
        return (AcquiredJobs)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new AcquireJobsCmd(this.processEngineConfiguration.getJobExecutor()));
    }
}

