/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DeploymentAwareJobExecutorForOracleTest {
    @ClassRule
    public static ProcessEngineBootstrapRule deploymentAwareBootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJobExecutorDeploymentAware(true));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(deploymentAwareBootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Test
    public void testFindAcquirableJobsWhen0InstancesDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        this.findAcquirableJobs();
    }

    @Test
    public void testFindAcquirableJobsWhen1InstanceDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        this.findAcquirableJobs();
    }

    @Test
    public void testFindAcquirableJobsWhen1000InstancesDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        for (int i = 0; i < 1000; ++i) {
            this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        }
        this.findAcquirableJobs();
    }

    @Test
    public void testFindAcquirableJobsWhen1001InstancesDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        for (int i = 0; i < 1001; ++i) {
            this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        }
        this.findAcquirableJobs();
    }

    @Test
    public void testFindAcquirableJobsWhen2000InstancesDeployed() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        for (int i = 0; i < 2000; ++i) {
            this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        }
        this.findAcquirableJobs();
    }

    protected List<AcquirableJobEntity> findAcquirableJobs() {
        return (List)this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<List<AcquirableJobEntity>>(){

            public List<AcquirableJobEntity> execute(CommandContext commandContext) {
                return commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
            }
        });
    }
}

