/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.impl.ProcessEngineImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.JobExecutorWaitUtils;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ExclusiveJobAcquisitionTest {
    private static final long MAX_SECONDS_TO_WAIT_ON_JOBS = 60L;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJobExecutor((JobExecutor)new AssertJobExecutor()));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private ProcessEngineConfigurationImpl engineConfig;
    private RuntimeService runtimeService;
    private ManagementService managementService;
    private AssertJobExecutor jobExecutor;

    @Before
    public void setup() {
        this.engineConfig = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.jobExecutor = (AssertJobExecutor)this.engineConfig.getJobExecutor();
    }

    @After
    public void tearDown() {
        this.jobExecutor.clear();
        this.jobExecutor.shutdown();
    }

    @Test
    public void shouldNotApplyExclusiveAcquisitionWhenMultipleHierarchiesExclusiveJobsIsDisabled() {
        this.engineConfig.setJobExecutorActivate(false);
        this.engineConfig.setJobExecutorAcquireExclusiveOverProcessHierarchies(false);
        this.jobExecutor.setMaxJobsPerAcquisition(10);
        this.jobExecutor.setCorePoolSize(1);
        BpmnModelInstance subModel = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"subProcess").startEvent().scriptTask("scriptTask").camundaAsyncBefore()).camundaExclusive(true)).scriptFormat("javascript")).scriptText("console.log(execution.getJobs())")).endEvent().done();
        BpmnModelInstance rootModel = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"rootProcess").startEvent().callActivity("callActivity").calledElement("subProcess")).multiInstance().parallel()).cardinality("2")).multiInstanceDone().endEvent().done();
        this.testRule.deploy(subModel, rootModel);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("rootProcess");
        ProcessInstance pi2 = this.runtimeService.startProcessInstanceByKey("rootProcess");
        Assertions.assertThat((List)this.managementService.createJobQuery().list()).hasSize(4);
        List<String> pi1Jobs = this.assertProcessInstanceJobs(pi1, 2, "subProcess");
        List<String> pi2Jobs = this.assertProcessInstanceJobs(pi2, 2, "subProcess");
        this.jobExecutor.start();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(60000L, 100L, (JobExecutor)this.jobExecutor, this.managementService, true);
        List<String> batch1_pi1_job1 = pi1Jobs.subList(0, 1);
        List<String> batch2_pi1_job2 = pi1Jobs.subList(1, 2);
        List<String> batch3_pi2_job1 = pi2Jobs.subList(0, 1);
        List<String> batch4_pi2_job2 = pi2Jobs.subList(1, 2);
        this.jobExecutor.assertJobGroup(batch1_pi1_job1, batch2_pi1_job2, batch3_pi2_job1, batch4_pi2_job2);
    }

    @Test
    public void shouldApplyExclusiveAcquisitionWhenAcquireExclusiveOverProcessHierarchiesIsEnabled() {
        this.engineConfig.setJobExecutorActivate(false);
        this.engineConfig.setJobExecutorAcquireExclusiveOverProcessHierarchies(true);
        this.jobExecutor.setMaxJobsPerAcquisition(10);
        BpmnModelInstance subModel = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"subProcess").startEvent().scriptTask("scriptTask").camundaAsyncBefore()).camundaExclusive(true)).scriptFormat("javascript")).scriptText("console.log(execution.getJobs())")).endEvent().done();
        BpmnModelInstance rootModel = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"rootProcess").startEvent().callActivity("callActivity").calledElement("subProcess")).multiInstance().parallel()).cardinality("2")).multiInstanceDone().endEvent().done();
        this.testRule.deploy(subModel, rootModel);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("rootProcess");
        ProcessInstance pi2 = this.runtimeService.startProcessInstanceByKey("rootProcess");
        Assertions.assertThat((List)this.managementService.createJobQuery().list()).hasSize(4);
        List<String> pi1Jobs = this.assertProcessInstanceJobs(pi1, 2, "subProcess");
        List<String> pi2Jobs = this.assertProcessInstanceJobs(pi2, 2, "subProcess");
        this.jobExecutor.start();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(60000L, 100L, (JobExecutor)this.jobExecutor, this.managementService, true);
        this.jobExecutor.assertJobGroup(pi1Jobs, pi2Jobs);
    }

    @Test
    public void shouldApplyExclusiveAcquisitionWhenAcquireExclusiveOverProcessHierarchiesIsEnabledMultiHierarchy() {
        this.engineConfig.setJobExecutorActivate(false);
        this.engineConfig.setJobExecutorAcquireExclusiveOverProcessHierarchies(true);
        this.jobExecutor.setMaxJobsPerAcquisition(10);
        BpmnModelInstance subSubModel = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"subSubProcess").startEvent().scriptTask("scriptTask").camundaAsyncBefore()).camundaExclusive(true)).scriptFormat("javascript")).scriptText("console.log(execution.getJobs())")).endEvent().done();
        BpmnModelInstance subModel = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"subProcess").startEvent().callActivity("callActivity").calledElement("subSubProcess")).multiInstance().parallel()).cardinality("2")).multiInstanceDone().endEvent().done();
        BpmnModelInstance rootModel = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"rootProcess").startEvent().callActivity("callActivity").calledElement("subProcess")).multiInstance().parallel()).cardinality("2")).multiInstanceDone().endEvent().done();
        this.testRule.deploy(subSubModel, subModel, rootModel);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("rootProcess");
        ProcessInstance pi2 = this.runtimeService.startProcessInstanceByKey("rootProcess");
        Assertions.assertThat((List)this.managementService.createJobQuery().list()).hasSize(8);
        List<String> pi1Jobs = this.assertProcessInstanceJobs(pi1, 4, "subSubProcess");
        List<String> pi2Jobs = this.assertProcessInstanceJobs(pi2, 4, "subSubProcess");
        this.jobExecutor.start();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(60000L, 100L, (JobExecutor)this.jobExecutor, this.managementService, true);
        this.jobExecutor.assertJobGroup(pi1Jobs, pi2Jobs);
    }

    private List<String> assertProcessInstanceJobs(ProcessInstance pi, int nJobs, String pdKey) {
        List jobs = this.managementService.createJobQuery().rootProcessInstanceId(pi.getId()).list();
        Assertions.assertThat((List)jobs).hasSize(nJobs);
        jobs.forEach(job -> {
            Assertions.assertThat((String)job.getProcessDefinitionKey()).isEqualTo((Object)pdKey);
            Assertions.assertThat((String)job.getRootProcessInstanceId()).isEqualTo((Object)pi.getId());
        });
        return jobs.stream().map(Job::getId).collect(Collectors.toList());
    }

    private static Set<String>[] asArrayOfSets(List<String> ... jobIds) {
        ArrayList<HashSet<String>> result = new ArrayList<HashSet<String>>();
        for (List<String> jobGroup : jobIds) {
            result.add(new HashSet<String>(jobGroup));
        }
        return result.toArray(new Set[0]);
    }

    static class AssertJobExecutor
    extends DefaultJobExecutor {
        final List<Set<String>> jobBatches = new ArrayList<Set<String>>();

        AssertJobExecutor() {
        }

        @SafeVarargs
        public final void assertJobGroup(List<String> ... jobIds) {
            Object[] jobGroups = ExclusiveJobAcquisitionTest.asArrayOfSets(jobIds);
            Assertions.assertThat(this.jobBatches).containsExactlyInAnyOrder(jobGroups);
        }

        public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
            super.executeJobs(jobIds, processEngine);
            System.out.println("jobIds = " + jobIds);
            this.jobBatches.add(new HashSet<String>(jobIds));
        }

        public void clear() {
            this.jobBatches.clear();
        }
    }
}

