/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.eximeebpms.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobAcquisitionBackoffIdleTest {
    public static final int BASE_IDLE_WAIT_TIME = 5000;
    public static final int MAX_IDLE_WAIT_TIME = 60000;
    protected ControllableJobExecutor jobExecutor;
    protected ConcurrencyTestHelper.ThreadControl acquisitionThread;
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        this.jobExecutor = new ControllableJobExecutor(true);
        this.jobExecutor.setMaxJobsPerAcquisition(1);
        this.jobExecutor.setWaitTimeInMillis(5000);
        this.jobExecutor.setMaxWait(60000L);
        this.acquisitionThread = this.jobExecutor.getAcquisitionThreadControl();
        configuration.setJobExecutor((JobExecutor)this.jobExecutor);
    });
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule);

    @After
    public void shutdownJobExecutor() {
        ClockUtil.reset();
        this.jobExecutor.shutdown();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testIdlingAfterConcurrentJobAddedNotification() {
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("simpleAsyncProcess");
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.assertJobExecutorWaitEvent(0L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(0L);
        this.cycleJobAcquisitionToMaxIdleTime();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/JobAcquisitionBackoffIdleTest.testShortTimerOnUserTaskWithExpression.bpmn20.xml"})
    public void testIdlingWithHintOnSuspend() {
        this.testIdlingWithHint(() -> {
            this.acquisitionThread.makeContinueAndWaitForSync();
            this.acquisitionThread.makeContinueAndWaitForSync();
            ProcessInstance procInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("timer-example");
            this.acquisitionThread.makeContinueAndWaitForSync();
            this.assertJobExecutorWaitEvent(60000L);
            this.triggerReconfigurationAndNextCycle();
            this.assertJobExecutorWaitEvent(0L);
            return procInstance;
        });
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/JobAcquisitionBackoffIdleTest.testShortTimerOnUserTaskWithExpression.bpmn20.xml"})
    public void testIdlingWithHintOnAcquisition() {
        this.testIdlingWithHint(() -> {
            this.acquisitionThread.makeContinueAndWaitForSync();
            ProcessInstance procInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("timer-example");
            this.acquisitionThread.makeContinueAndWaitForSync();
            this.acquisitionThread.makeContinueAndWaitForSync();
            this.assertJobExecutorWaitEvent(0L);
            return procInstance;
        });
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/JobAcquisitionBackoffIdleTest.testShortTimerOnUserTaskWithExpression.bpmn20.xml"})
    public void testIdlingWithHintBeforeAcquisition() {
        this.testIdlingWithHint(() -> {
            ProcessInstance procInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("timer-example");
            this.acquisitionThread.makeContinueAndWaitForSync();
            this.acquisitionThread.makeContinueAndWaitForSync();
            this.acquisitionThread.makeContinueAndWaitForSync();
            this.assertJobExecutorWaitEvent(0L);
            return procInstance;
        });
    }

    protected void testIdlingWithHint(JobCreationInCycle jobCreationInCycle) {
        this.initAcquisitionAndIdleToMaxTime();
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        ProcessInstance procInstance = jobCreationInCycle.createJobAndContinueCycle();
        Task task1 = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        TestCase.assertEquals((String)"Timer Task", (String)task1.getName());
        JobQuery jobQuery = this.engineRule.getManagementService().createJobQuery().processInstanceId(procInstance.getId());
        Job job = (Job)jobQuery.singleResult();
        TestCase.assertNotNull((Object)job);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(5000L);
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 5000L));
        this.cycleAcquisitionAndAssertAfterJobExecution(jobQuery);
    }

    protected void initAcquisitionAndIdleToMaxTime() {
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.cycleJobAcquisitionToMaxIdleTime();
    }

    protected void cycleJobAcquisitionToMaxIdleTime() {
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(5000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(10000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(20000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(40000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(60000L);
    }

    protected void triggerReconfigurationAndNextCycle() {
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
    }

    protected void cycleAcquisitionAndAssertAfterJobExecution(JobQuery jobQuery) {
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(0L);
        TestCase.assertEquals((long)0L, (long)jobQuery.count());
        TestCase.assertEquals((long)1L, (long)this.engineRule.getTaskService().createTaskQuery().count());
        Task task = (Task)((TaskQuery)this.engineRule.getTaskService().createTaskQuery().orderByTaskName().desc()).singleResult();
        TestCase.assertEquals((String)"Next Task", (String)task.getName());
        this.engineRule.getTaskService().complete(task.getId());
    }

    protected void assertJobExecutorWaitEvent(long expectedTimeout) {
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> waitEvents = this.jobExecutor.getAcquireJobsRunnable().getWaitEvents();
        TestCase.assertEquals((int)1, (int)waitEvents.size());
        TestCase.assertEquals((long)expectedTimeout, (long)waitEvents.get(0).getTimeBetweenAcquisitions());
        waitEvents.clear();
    }

    public static interface JobCreationInCycle {
        public ProcessInstance createJobAndContinueCycle();
    }
}

