/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;
import org.eximeebpms.bpm.engine.impl.util.xml.Element;
import org.eximeebpms.bpm.engine.management.JobDefinitionQuery;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.jobexecutor.JobDefinitionCreationWithParseListenerTest;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class JobDefinitionDeletionWithParseListenerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        ArrayList<1> listeners = new ArrayList<1>();
        listeners.add(new AbstractBpmnParseListener(){

            public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
                activity.setAsyncBefore(false);
            }
        });
        configuration.setCustomPreBPMNParseListeners(listeners);
    });
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);

    @Test
    public void testDeleteNonExistingJobDefinitionWithParseListener() {
        String modelFileName = "jobCreationWithinParseListener.bpmn20.xml";
        InputStream in = JobDefinitionCreationWithParseListenerTest.class.getResourceAsStream(modelFileName);
        DeploymentBuilder builder = this.engineRule.getRepositoryService().createDeployment().addInputStream(modelFileName, in);
        Deployment deployment = builder.deploy();
        this.engineRule.manageDeployment(deployment);
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        TestCase.assertNull((Object)query.singleResult());
    }

    @Test
    public void testDeleteJobDefinitionWithParseListenerAndAsyncInXml() {
        String modelFileName = "jobAsyncBeforeCreationWithinParseListener.bpmn20.xml";
        InputStream in = JobDefinitionCreationWithParseListenerTest.class.getResourceAsStream(modelFileName);
        DeploymentBuilder builder = this.engineRule.getRepositoryService().createDeployment().addInputStream(modelFileName, in);
        Deployment deployment = builder.deploy();
        this.engineRule.manageDeployment(deployment);
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        TestCase.assertNull((Object)query.singleResult());
    }
}

