/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;

public class JobDefinitionFunctionalTest {
    static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected static final BpmnModelInstance SIMPLE_ASYNC_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"simpleAsyncProcess").startEvent().serviceTask().camundaExpression("${true}")).camundaAsyncBefore()).endEvent().done();

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void testCreateJobInstanceSuspended() {
        this.testRule.deploy(SIMPLE_ASYNC_PROCESS);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("simpleAsyncProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Assert.assertNotNull((Object)this.managementService.createJobQuery().suspended().singleResult());
        Assert.assertNull((Object)this.managementService.createJobQuery().active().singleResult());
    }

    @Test
    public void testCreateJobInstanceActive() {
        this.testRule.deploy(SIMPLE_ASYNC_PROCESS);
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Assert.assertNull((Object)this.managementService.createJobQuery().suspended().singleResult());
        Assert.assertNotNull((Object)this.managementService.createJobQuery().active().singleResult());
    }

    @Test
    public void testJobExecutorOnlyAcquiresActiveJobs() {
        this.testRule.deploy(SIMPLE_ASYNC_PROCESS);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("simpleAsyncProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        AcquiredJobs acquiredJobs = this.acquireJobs();
        Assert.assertEquals((long)0L, (long)acquiredJobs.size());
        this.managementService.activateJobDefinitionByProcessDefinitionKey("simpleAsyncProcess", true);
        acquiredJobs = this.acquireJobs();
        Assert.assertEquals((long)1L, (long)acquiredJobs.size());
    }

    @Test
    public void testExclusiveJobs() {
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().serviceTask("task1").camundaExpression("${true}")).camundaAsyncBefore()).serviceTask("task2").camundaExpression("${true}")).camundaAsyncBefore()).endEvent().done());
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"task2"}).singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.testRule.waitForJobExecutorToProcessAllJobs(10000L);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)jobDefinition.getId());
        Assert.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), true);
        this.testRule.waitForJobExecutorToProcessAllJobs(10000L);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    protected AcquiredJobs acquireJobs() {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        return (AcquiredJobs)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new AcquireJobsCmd(jobExecutor));
    }
}

