/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import ch.qos.logback.classic.Level;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.CallerRunsRejectedJobsHandler;
import org.eximeebpms.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobExecutionLoggingTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch("org.eximeebpms.bpm.engine.jobexecutor", Level.DEBUG);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.loggingRule);
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/SimpleAsyncDelayProcess.bpmn20.xml"})
    public void shouldLogJobsQueuedForExecution() {
        TestJobExecutor testJobExecutor = new TestJobExecutor();
        testJobExecutor.setMaxJobsPerAcquisition(10);
        this.processEngineConfiguration.setJobExecutor((JobExecutor)testJobExecutor);
        testJobExecutor.registerProcessEngine(this.processEngineConfiguration.getProcessEngine());
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.startProcessInstanceByKey("simpleAsyncDelayProcess");
        }
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs(7000L);
        this.processEngineConfiguration.getJobExecutor().shutdown();
        List filteredLogList = this.loggingRule.getFilteredLog("Jobs currently in queue to be executed for the process engine '" + this.processEngineConfiguration.getProcessEngineName() + "' : 2 (out of the max queue size : " + testJobExecutor.queueSize + ")");
        Assertions.assertThat((int)filteredLogList.size()).isGreaterThanOrEqualTo(1);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/SimpleAsyncDelayProcess.bpmn20.xml"})
    public void shouldLogJobsInExecution() {
        TestJobExecutor testJobExecutor = new TestJobExecutor();
        this.processEngineConfiguration.setJobExecutor((JobExecutor)testJobExecutor);
        testJobExecutor.registerProcessEngine(this.processEngineConfiguration.getProcessEngine());
        this.runtimeService.startProcessInstanceByKey("simpleAsyncDelayProcess");
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        this.processEngineConfiguration.getJobExecutor().shutdown();
        List filteredLogList = this.loggingRule.getFilteredLog("Jobs currently in execution for the process engine '" + this.processEngineConfiguration.getProcessEngineName() + "' : 1");
        Assertions.assertThat((int)filteredLogList.size()).isGreaterThanOrEqualTo(1);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/SimpleAsyncDelayProcess.bpmn20.xml"})
    public void shouldLogAvailableJobExecutionThreads() {
        TestJobExecutor testJobExecutor = new TestJobExecutor();
        this.processEngineConfiguration.setJobExecutor((JobExecutor)testJobExecutor);
        testJobExecutor.registerProcessEngine(this.processEngineConfiguration.getProcessEngine());
        this.runtimeService.startProcessInstanceByKey("simpleAsyncDelayProcess");
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        this.processEngineConfiguration.getJobExecutor().shutdown();
        List filteredLogList = this.loggingRule.getFilteredLog("Available job execution threads for the process engine '" + this.processEngineConfiguration.getProcessEngineName() + "' : 2");
        Assertions.assertThat((int)filteredLogList.size()).isGreaterThanOrEqualTo(1);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/delegateThrowsException.bpmn20.xml"})
    public void shouldLogJobExecutionRejections() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("testProcess");
        }
        RejectionJobExecutor rejectionExecutor = new RejectionJobExecutor();
        this.processEngineConfiguration.setJobExecutor((JobExecutor)rejectionExecutor);
        rejectionExecutor.registerProcessEngine(this.processEngineConfiguration.getProcessEngine());
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        this.processEngineConfiguration.getJobExecutor().shutdown();
        List filteredLogList = this.loggingRule.getFilteredLog("Jobs execution rejections for the process engine '" + this.processEngineConfiguration.getProcessEngineName() + "' : ");
        Assertions.assertThat((int)filteredLogList.size()).isGreaterThanOrEqualTo(3);
    }

    public static class TestJobExecutor
    extends DefaultJobExecutor {
        protected int queueSize = 2;
        protected int corePoolSize = 1;
        protected int maxPoolSize = 3;
        protected BlockingQueue<Runnable> threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);

        public TestJobExecutor() {
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 0L, TimeUnit.MILLISECONDS, this.threadPoolQueue);
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        }
    }

    public static class RejectionJobExecutor
    extends TestJobExecutor {
        public RejectionJobExecutor() {
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 0L, TimeUnit.MILLISECONDS, this.threadPoolQueue){

                @Override
                public void execute(Runnable command) {
                    throw new RejectedExecutionException();
                }
            };
            this.rejectedJobsHandler = new CallerRunsRejectedJobsHandler();
        }
    }
}

