/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorAcquireCleanupJobsTest
extends AbstractJobExecutorAcquireJobsTest {
    public HistoryService historyService;

    @Before
    public void assignServices() {
        this.historyService = this.rule.getHistoryService();
    }

    @Test
    public void shouldNotAcquireJobsWhenCleanupDisabled() {
        this.historyService.cleanUpHistoryAsync(true);
        this.configuration.setHistoryCleanupEnabled(false);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assertions.assertThat((List)historyCleanupJobs).isNotEmpty();
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).isEmpty();
        this.configuration.setHistoryCleanupEnabled(true);
    }

    @Test
    public void shouldAcquireJobsWhenCleanupEnabled() {
        this.historyService.cleanUpHistoryAsync(true);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assertions.assertThat((List)historyCleanupJobs).isNotEmpty();
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).isNotEmpty();
    }

    @After
    public void resetDatabase() {
        this.configuration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                String handlerType = "history-cleanup";
                List jobsByHandlerType = commandContext.getJobManager().findJobsByHandlerType(handlerType);
                for (Job job : jobsByHandlerType) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                }
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType(handlerType);
                return null;
            }
        });
    }
}

