/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.eximeebpms.commons.testing.WatchLogger;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/JobExecutorAcquireJobsForPriorityRangeTest.jobPrioProcess.bpmn20.xml"})
public class JobExecutorAcquireJobsForPriorityRangeTest
extends AbstractJobExecutorAcquireJobsTest {
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();

    @Before
    public void setUp() {
        this.configuration.setJobExecutorAcquireByPriority(true);
        this.createJobs();
    }

    @Test
    public void shouldAcquireAllJobs() {
        int i;
        this.configuration.setJobExecutorPriorityRangeMin(0L);
        this.configuration.setJobExecutorPriorityRangeMax(Long.MAX_VALUE);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(10);
        for (i = 0; i < 5; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(10L);
        }
        for (i = 5; i < 10; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(5L);
        }
    }

    @Test
    public void shouldAcquireOnlyJobsInRangeWithUpperBound() {
        this.configuration.setJobExecutorPriorityRangeMin(0L);
        this.configuration.setJobExecutorPriorityRangeMax(7L);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(5L);
        }
    }

    @Test
    public void shouldAcquireOnlyJobsInRangeWithLowerBound() {
        this.configuration.setJobExecutorPriorityRangeMin(7L);
        this.configuration.setJobExecutorPriorityRangeMax(Long.MAX_VALUE);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(10L);
        }
    }

    @Test
    public void shouldAcquireOnlyJobsInBoundWithUpperAndLowerBound() {
        this.configuration.setJobExecutorPriorityRangeMin(7L);
        this.configuration.setJobExecutorPriorityRangeMax(12L);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(10L);
        }
    }

    @Test
    public void shouldAcquireOnlyJobsInBoundWithUpperAndLowerBoundNoJobsFound() {
        this.configuration.setJobExecutorPriorityRangeMin(12L);
        this.configuration.setJobExecutorPriorityRangeMax(15L);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(0);
    }

    @Test
    public void shouldAcquireJobsWithNegativePriorityInRange() {
        this.configuration.setJobExecutorPriorityRangeMin(-5L);
        this.startProcess("jobPrioProcess", "task3", 1);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Job jobWithNegativePrio = (Job)this.managementService.createJobQuery().priorityLowerThanOrEquals(-5L).singleResult();
        Assertions.assertThat(acquirableJobs).extracting("id").contains(new Object[]{jobWithNegativePrio.getId()});
    }

    @Test
    public void shouldSetDefaultPriorityRange() {
        Assertions.assertThat((long)this.configuration.getJobExecutorPriorityRangeMin()).isEqualTo(Long.MIN_VALUE);
        Assertions.assertThat((long)this.configuration.getJobExecutorPriorityRangeMax()).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    public void shouldAcquireAllJobsWhenDefaultPriorityRange() {
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(10);
    }

    @Test
    @WatchLogger(loggerNames={"org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity"}, level="debug")
    public void shouldDisableRangeCheckInQueryWhenDefaultConfig() {
        this.configuration.setJobExecutorAcquireByPriority(false);
        this.findAcquirableJobs();
        List log = this.loggingRule.getFilteredLog("RES.PRIORITY_ >= ? and RES.PRIORITY_ <= ?");
        Assertions.assertThat((List)log).hasSize(0);
    }

    @Test
    @WatchLogger(loggerNames={"org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity"}, level="debug")
    public void shouldEnableRangeCheckInQueryWhenUsingCustomMinBoundaryConfig() {
        this.configuration.setJobExecutorPriorityRangeMin(6L);
        this.findAcquirableJobs();
        List logRangeMinCheck = this.loggingRule.getFilteredLog("RES.PRIORITY_ >= ?");
        Assertions.assertThat((List)logRangeMinCheck).hasSize(1);
        List logRangeMaxCheck = this.loggingRule.getFilteredLog("RES.PRIORITY_ <= ?");
        Assertions.assertThat((List)logRangeMaxCheck).hasSize(0);
    }

    @Test
    @WatchLogger(loggerNames={"org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity"}, level="debug")
    public void shouldEnableRangeCheckInQueryWhenUsingCustomMaxBoundaryConfig() {
        this.configuration.setJobExecutorPriorityRangeMax(11L);
        this.findAcquirableJobs();
        List logRangeMinCheck = this.loggingRule.getFilteredLog("RES.PRIORITY_ >= ?");
        Assertions.assertThat((List)logRangeMinCheck).hasSize(0);
        List logRangeMaxCheck = this.loggingRule.getFilteredLog("RES.PRIORITY_ <= ?");
        Assertions.assertThat((List)logRangeMaxCheck).hasSize(1);
    }

    private void createJobs() {
        this.startProcess("jobPrioProcess", "task1", 5);
        this.startProcess("jobPrioProcess", "task2", 5);
    }
}

