/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquireJobsCommandFactory;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.eximeebpms.bpm.engine.impl.jobexecutor.DefaultAcquireJobsCommandFactory;
import org.eximeebpms.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorStartTest {
    private JobExecutor jobExecutor;

    @Before
    public void setUp() throws Exception {
        this.jobExecutor = new DefaultJobExecutor();
    }

    @After
    public void tearDown() throws Exception {
        this.jobExecutor.shutdown();
    }

    @Test
    public void shouldUseDefaultInitialization() {
        this.jobExecutor.start();
        Assertions.assertThat((Object)this.jobExecutor.getAcquireJobsCmdFactory()).isNotNull();
        Assertions.assertThat((Object)this.jobExecutor.getAcquireJobsRunnable()).isNotNull();
        Assertions.assertThat((Object)this.jobExecutor.getAcquireJobsCmdFactory()).isInstanceOf(DefaultAcquireJobsCommandFactory.class);
        Assertions.assertThat((boolean)this.jobExecutor.isActive()).isTrue();
    }

    @Test
    public void shouldUseCustomJobsCmdFactoryAfterInitialization() {
        MyAcquireJobsCmdFactory myFactory = new MyAcquireJobsCmdFactory();
        this.jobExecutor.setAcquireJobsCmdFactory((AcquireJobsCommandFactory)myFactory);
        this.jobExecutor.start();
        Assertions.assertThat((Object)this.jobExecutor.getAcquireJobsCmdFactory()).isSameAs((Object)myFactory);
        Assertions.assertThat((boolean)this.jobExecutor.isActive()).isTrue();
    }

    public static class MyAcquireJobsCmdFactory
    implements AcquireJobsCommandFactory {
        public Command<AcquiredJobs> getCommand(int numJobsToAcquire) {
            return null;
        }
    }
}

