/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobManager;
import org.eximeebpms.bpm.engine.test.jobexecutor.JobExecutorTestCase;
import org.junit.Assert;
import org.junit.Test;

public class JobExecutorTest
extends JobExecutorTestCase {
    @Test
    public void testBasicJobExecutorOperation() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                jobManager.send(JobExecutorTest.this.createTweetMessage("message-one"));
                jobManager.send(JobExecutorTest.this.createTweetMessage("message-two"));
                jobManager.send(JobExecutorTest.this.createTweetMessage("message-three"));
                jobManager.send(JobExecutorTest.this.createTweetMessage("message-four"));
                jobManager.schedule(JobExecutorTest.this.createTweetTimer("timer-one", new Date()));
                jobManager.schedule(JobExecutorTest.this.createTweetTimer("timer-two", new Date()));
                return null;
            }
        });
        this.testRule.executeAvailableJobs();
        HashSet<String> messages = new HashSet<String>(this.tweetHandler.getMessages());
        HashSet<String> expectedMessages = new HashSet<String>();
        expectedMessages.add("message-one");
        expectedMessages.add("message-two");
        expectedMessages.add("message-three");
        expectedMessages.add("message-four");
        expectedMessages.add("timer-one");
        expectedMessages.add("timer-two");
        Assert.assertEquals(new TreeSet(expectedMessages), new TreeSet<String>(messages));
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List historicJobLogs = JobExecutorTest.this.processEngineConfiguration.getHistoryService().createHistoricJobLogQuery().list();
                for (HistoricJobLog historicJobLog : historicJobLogs) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogById(historicJobLog.getId());
                }
                return null;
            }
        });
    }

    @Test
    public void testJobExecutorHintConfiguration() {
        ProcessEngineConfiguration engineConfig1 = ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration();
        Assert.assertTrue((String)"default setting is true", (boolean)engineConfig1.isHintJobExecutor());
        ProcessEngineConfiguration engineConfig2 = ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration().setHintJobExecutor(false);
        Assert.assertFalse((boolean)engineConfig2.isHintJobExecutor());
        ProcessEngineConfiguration engineConfig3 = ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration().setHintJobExecutor(true);
        Assert.assertTrue((boolean)engineConfig3.isHintJobExecutor());
    }

    @Test
    public void testAcquiredJobs() {
        ArrayList<String> firstBatch = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        ArrayList<String> secondBatch = new ArrayList<String>(Arrays.asList("d", "e", "f"));
        ArrayList<String> thirdBatch = new ArrayList<String>(Arrays.asList("g"));
        AcquiredJobs acquiredJobs = new AcquiredJobs(0);
        acquiredJobs.addJobIdBatch(firstBatch);
        acquiredJobs.addJobIdBatch(secondBatch);
        acquiredJobs.addJobIdBatch(thirdBatch);
        Assert.assertEquals(firstBatch, acquiredJobs.getJobIdBatches().get(0));
        Assert.assertEquals(secondBatch, acquiredJobs.getJobIdBatches().get(1));
        Assert.assertEquals(thirdBatch, acquiredJobs.getJobIdBatches().get(2));
        acquiredJobs.removeJobId("a");
        Assert.assertEquals(Arrays.asList("b", "c"), acquiredJobs.getJobIdBatches().get(0));
        Assert.assertEquals(secondBatch, acquiredJobs.getJobIdBatches().get(1));
        Assert.assertEquals(thirdBatch, acquiredJobs.getJobIdBatches().get(2));
        Assert.assertEquals((long)3L, (long)acquiredJobs.getJobIdBatches().size());
        acquiredJobs.removeJobId("g");
        Assert.assertEquals((long)2L, (long)acquiredJobs.getJobIdBatches().size());
    }
}

