/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngines;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.test.util.JobExecutorWaitUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SequentialJobAcquisitionTest {
    private static final String RESOURCE_BASE = SequentialJobAcquisitionTest.class.getPackage().getName().replace(".", "/");
    private static final String PROCESS_RESOURCE = RESOURCE_BASE + "/IntermediateTimerEventTest.testCatchingTimerEvent.bpmn20.xml";
    private JobExecutor jobExecutor = new DefaultJobExecutor();
    private List<ProcessEngine> createdProcessEngines = new ArrayList<ProcessEngine>();

    @After
    public void stopJobExecutor() {
        this.jobExecutor.shutdown();
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void closeProcessEngines() {
        Iterator<ProcessEngine> iterator = this.createdProcessEngines.iterator();
        while (iterator.hasNext()) {
            ProcessEngine processEngine = iterator.next();
            processEngine.close();
            ProcessEngines.unregister((ProcessEngine)processEngine);
            iterator.remove();
        }
    }

    @Test
    public void testExecuteJobsForSingleEngine() {
        StandaloneInMemProcessEngineConfiguration standaloneProcessEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        standaloneProcessEngineConfiguration.setProcessEngineName(this.getClass().getName() + "-engine1");
        standaloneProcessEngineConfiguration.setJdbcUrl("jdbc:h2:mem:jobexecutor-test-engine");
        standaloneProcessEngineConfiguration.setJobExecutorActivate(false);
        standaloneProcessEngineConfiguration.setJobExecutor(this.jobExecutor);
        standaloneProcessEngineConfiguration.setDbMetricsReporterActivate(false);
        ProcessEngine engine = standaloneProcessEngineConfiguration.buildProcessEngine();
        this.createdProcessEngines.add(engine);
        engine.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        this.jobExecutor.shutdown();
        engine.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
        Assert.assertEquals((long)1L, (long)engine.getManagementService().createJobQuery().count());
        Calendar calendar = Calendar.getInstance();
        calendar.add(DateFormat.Field.DAY_OF_YEAR.getCalendarField(), 6);
        ClockUtil.setCurrentTime((Date)calendar.getTime());
        this.jobExecutor.start();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine.getManagementService(), true);
        Assert.assertEquals((long)0L, (long)engine.getManagementService().createJobQuery().count());
    }

    @Test
    public void testExecuteJobsForTwoEnginesSameAcquisition() {
        StandaloneInMemProcessEngineConfiguration engineConfiguration1 = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration1.setProcessEngineName(this.getClass().getName() + "-engine1");
        engineConfiguration1.setJdbcUrl("jdbc:h2:mem:activiti1");
        engineConfiguration1.setJobExecutorActivate(false);
        engineConfiguration1.setJobExecutor(this.jobExecutor);
        engineConfiguration1.setDbMetricsReporterActivate(false);
        ProcessEngine engine1 = engineConfiguration1.buildProcessEngine();
        this.createdProcessEngines.add(engine1);
        StandaloneInMemProcessEngineConfiguration engineConfiguration2 = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration2.setProcessEngineName(this.getClass().getName() + "engine2");
        engineConfiguration2.setJdbcUrl("jdbc:h2:mem:activiti2");
        engineConfiguration2.setJobExecutorActivate(false);
        engineConfiguration2.setJobExecutor(this.jobExecutor);
        engineConfiguration2.setDbMetricsReporterActivate(false);
        engineConfiguration2.setEnforceHistoryTimeToLive(false);
        ProcessEngine engine2 = engineConfiguration2.buildProcessEngine();
        this.createdProcessEngines.add(engine2);
        this.jobExecutor.shutdown();
        engine1.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        engine2.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        engine1.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
        engine2.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
        Assert.assertEquals((long)1L, (long)engine1.getManagementService().createJobQuery().count());
        Assert.assertEquals((long)1L, (long)engine2.getManagementService().createJobQuery().count());
        Calendar calendar = Calendar.getInstance();
        calendar.add(DateFormat.Field.DAY_OF_YEAR.getCalendarField(), 6);
        ClockUtil.setCurrentTime((Date)calendar.getTime());
        this.jobExecutor.start();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine1.getManagementService(), true);
        this.jobExecutor.start();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine2.getManagementService(), true);
        Assert.assertEquals((long)0L, (long)engine1.getManagementService().createJobQuery().count());
        Assert.assertEquals((long)0L, (long)engine2.getManagementService().createJobQuery().count());
    }

    @Test
    public void testJobAddedGuardForTwoEnginesSameAcquisition() throws InterruptedException {
        StandaloneInMemProcessEngineConfiguration engineConfiguration1 = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration1.setProcessEngineName(this.getClass().getName() + "-engine1");
        engineConfiguration1.setJdbcUrl("jdbc:h2:mem:activiti1");
        engineConfiguration1.setJobExecutorActivate(false);
        engineConfiguration1.setJobExecutor(this.jobExecutor);
        engineConfiguration1.setDbMetricsReporterActivate(false);
        ProcessEngine engine1 = engineConfiguration1.buildProcessEngine();
        this.createdProcessEngines.add(engine1);
        StandaloneInMemProcessEngineConfiguration engineConfiguration2 = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration2.setProcessEngineName(this.getClass().getName() + "engine2");
        engineConfiguration2.setJdbcUrl("jdbc:h2:mem:activiti2");
        engineConfiguration2.setJobExecutorActivate(false);
        engineConfiguration2.setJobExecutor(this.jobExecutor);
        engineConfiguration2.setDbMetricsReporterActivate(false);
        ProcessEngine engine2 = engineConfiguration2.buildProcessEngine();
        this.createdProcessEngines.add(engine2);
        this.jobExecutor.shutdown();
        engine1.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        engine2.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        engine1.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
        engine2.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
        Calendar calendar = Calendar.getInstance();
        calendar.add(DateFormat.Field.DAY_OF_YEAR.getCalendarField(), 6);
        ClockUtil.setCurrentTime((Date)calendar.getTime());
        Assert.assertEquals((long)1L, (long)engine1.getManagementService().createJobQuery().count());
        Assert.assertEquals((long)1L, (long)engine2.getManagementService().createJobQuery().count());
        this.jobExecutor.start();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine1.getManagementService(), false);
        this.jobExecutor.start();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine2.getManagementService(), false);
        JobExecutorWaitUtils.waitForJobExecutionRunnablesToFinish(10000L, 100L, this.jobExecutor);
        Thread.sleep(2000L);
        Assert.assertFalse((boolean)this.jobExecutor.getAcquireJobsRunnable().isJobAdded());
        Assert.assertEquals((long)0L, (long)engine1.getManagementService().createJobQuery().count());
        Assert.assertEquals((long)0L, (long)engine2.getManagementService().createJobQuery().count());
    }
}

