/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.calendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eximeebpms.bpm.engine.impl.calendar.DurationBusinessCalendar;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DurationBusinessCalendarTest {
    @After
    public void tearDown() {
        ClockUtil.reset();
    }

    @Test
    public void testSimpleDuration() throws Exception {
        DurationBusinessCalendar businessCalendar = new DurationBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2010 06 11 - 17:23");
        ClockUtil.setCurrentTime((Date)now);
        Date duedate = businessCalendar.resolveDuedate("P2DT5H70M");
        Date expectedDuedate = simpleDateFormat.parse("2010 06 13 - 23:33");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }

    @Test
    public void testSimpleDurationWithStartDate() throws Exception {
        DurationBusinessCalendar businessCalendar = new DurationBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2010 06 11 - 17:23");
        Date duedate = businessCalendar.resolveDuedate("P2DT5H70M", now);
        Date expectedDuedate = simpleDateFormat.parse("2010 06 13 - 23:33");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }
}

