/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.deploy;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.repository.DeploymentWithDefinitions;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DeploymentTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setJdbcUrl("jdbc:h2:mem:DeploymentTest-HistoryLevelNone;DB_CLOSE_DELAY=1000");
        configuration.setDatabaseSchemaUpdate("create-drop");
        configuration.setHistoryLevel(HistoryLevel.HISTORY_LEVEL_NONE);
        configuration.setDbHistoryUsed(false);
    });
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    public void shouldDeleteDeployment() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        DeploymentWithDefinitions deployment = this.engineRule.getRepositoryService().createDeployment().addModelInstance("foo.bpmn", instance).deployWithResult();
        this.engineRule.getRepositoryService().deleteDeployment(deployment.getId(), true);
        long count = this.engineRule.getRepositoryService().createDeploymentQuery().count();
        Assertions.assertThat((long)count).isEqualTo(0L);
    }

    @Test
    public void shouldDeleteDeploymentWithRunningInstance() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("testTask").endEvent().done();
        DeploymentWithDefinitions deployment = this.engineRule.getRepositoryService().createDeployment().addModelInstance("foo.bpmn", instance).deployWithResult();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Assertions.assertThat((long)this.engineRule.getRuntimeService().createProcessInstanceQuery().count()).isEqualTo(1L);
        this.engineRule.getRepositoryService().deleteDeployment(deployment.getId(), true);
        long count = this.engineRule.getRepositoryService().createDeploymentQuery().count();
        Assertions.assertThat((long)count).isEqualTo(0L);
    }
}

