/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Date;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.pvm.PvmActivity;
import org.eximeebpms.bpm.engine.impl.pvm.PvmTransition;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.TransitionImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.eximeebpms.bpm.engine.impl.task.TaskDefinition;
import org.eximeebpms.bpm.engine.task.DelegationState;
import org.eximeebpms.bpm.engine.test.standalone.entity.TestExecutionListener;
import org.junit.Assert;
import org.junit.Test;

public class EntitySerializationTest {
    @Test
    public void testTaskEntitySerialization() throws Exception {
        TaskEntity task = new TaskEntity();
        task.setDelegationState(DelegationState.RESOLVED);
        task.setExecution((PvmExecutionImpl)new ExecutionEntity());
        task.setProcessInstance(new ExecutionEntity());
        task.setTaskDefinition(new TaskDefinition(null));
        task.setAssignee("kermit");
        task.setCreateTime(new Date());
        task.setDescription("Test description");
        task.setDueDate(new Date());
        task.setName("myTask");
        task.setEventName("end");
        task.setDeleted(false);
        task.setDelegationStateString(DelegationState.RESOLVED.name());
        byte[] data = this.writeObject(task);
        task = (TaskEntity)this.readObject(data);
        Assert.assertEquals((Object)"kermit", (Object)task.getAssignee());
        Assert.assertEquals((Object)"myTask", (Object)task.getName());
        Assert.assertEquals((Object)"end", (Object)task.getEventName());
    }

    @Test
    public void testExecutionEntitySerialization() throws Exception {
        ExecutionEntity execution = new ExecutionEntity();
        ActivityImpl activityImpl = new ActivityImpl("test", null);
        activityImpl.getExecutionListeners().put("start", Collections.singletonList(new TestExecutionListener()));
        execution.setActivity((PvmActivity)activityImpl);
        ProcessDefinitionImpl processDefinitionImpl = new ProcessDefinitionImpl("test");
        processDefinitionImpl.getExecutionListeners().put("start", Collections.singletonList(new TestExecutionListener()));
        execution.setProcessDefinition(processDefinitionImpl);
        TransitionImpl transitionImpl = new TransitionImpl("test", new ProcessDefinitionImpl("test"));
        transitionImpl.addExecutionListener((ExecutionListener)new TestExecutionListener());
        execution.setTransition((PvmTransition)transitionImpl);
        execution.setSuperExecution((PvmExecutionImpl)new ExecutionEntity());
        execution.setActive(true);
        execution.setCanceled(false);
        execution.setBusinessKey("myBusinessKey");
        execution.setDeleteReason("no reason");
        execution.setActivityInstanceId("123");
        execution.setScope(false);
        byte[] data = this.writeObject(execution);
        execution = (ExecutionEntity)this.readObject(data);
        Assert.assertEquals((Object)"myBusinessKey", (Object)execution.getBusinessKey());
        Assert.assertEquals((Object)"no reason", (Object)execution.getDeleteReason());
        Assert.assertEquals((Object)"123", (Object)execution.getActivityInstanceId());
    }

    private byte[] writeObject(Object object) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
        outputStream.writeObject(object);
        outputStream.flush();
        outputStream.close();
        return buffer.toByteArray();
    }

    private Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(data);
        ObjectInputStream inputStream = new ObjectInputStream(buffer);
        Object object = inputStream.readObject();
        return object;
    }
}

