/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.entity;

import java.util.List;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.standalone.entity.ExecutionOrderListener;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExecutionSequenceCounterTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() {
        ExecutionOrderListener.clearActivityExecutionOrder();
    }

    @Deployment
    @Test
    public void testSequence() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theService2", "theEnd");
    }

    @Deployment
    @Test
    public void testForkSameSequenceLengthWithoutWaitStates() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService", "fork", "theService1", "theEnd1", "theService2", "theEnd2");
    }

    @Deployment
    @Test
    public void testForkSameSequenceLengthWithAsyncEndEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)5L, (long)order.size());
        long lastSequenceCounter = 0L;
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        Assert.assertEquals((Object)"theStart", (Object)theStartElement.getActivityId());
        Assert.assertTrue((theStartElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theStartElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theForkElement = order.get(1);
        Assert.assertEquals((Object)"theService", (Object)theForkElement.getActivityId());
        Assert.assertTrue((theForkElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceElement = order.get(2);
        Assert.assertEquals((Object)"fork", (Object)theServiceElement.getActivityId());
        Assert.assertTrue((theServiceElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theServiceElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(3);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(4);
        Assert.assertEquals((Object)"theService2", (Object)theService2Element.getActivityId());
        Assert.assertTrue((theService2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theEnd1").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)6L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(5);
        Assert.assertEquals((Object)"theEnd1", (Object)theEnd1Element.getActivityId());
        Assert.assertTrue((theEnd1Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theEnd2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.testRule.assertProcessEnded(processInstanceId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)7L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(6);
        Assert.assertEquals((Object)"theEnd2", (Object)theEnd2Element.getActivityId());
        Assert.assertTrue((theEnd2Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testForkDifferentSequenceLengthWithoutWaitStates() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService", "fork", "theService1", "theEnd1", "theService2", "theService3", "theEnd2");
    }

    @Deployment
    @Test
    public void testForkDifferentSequenceLengthWithAsyncEndEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)6L, (long)order.size());
        long lastSequenceCounter = 0L;
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        Assert.assertEquals((Object)"theStart", (Object)theStartElement.getActivityId());
        Assert.assertTrue((theStartElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theStartElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theForkElement = order.get(1);
        Assert.assertEquals((Object)"theService", (Object)theForkElement.getActivityId());
        Assert.assertTrue((theForkElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceElement = order.get(2);
        Assert.assertEquals((Object)"fork", (Object)theServiceElement.getActivityId());
        Assert.assertTrue((theServiceElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theServiceElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(3);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(4);
        Assert.assertEquals((Object)"theService2", (Object)theService2Element.getActivityId());
        Assert.assertTrue((theService2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(5);
        Assert.assertEquals((Object)"theService3", (Object)theService3Element.getActivityId());
        Assert.assertTrue((theService3Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theEnd1").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)7L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(6);
        Assert.assertEquals((Object)"theEnd1", (Object)theEnd1Element.getActivityId());
        Assert.assertTrue((theEnd1Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theEnd2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.testRule.assertProcessEnded(processInstanceId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)8L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(7);
        Assert.assertEquals((Object)"theEnd2", (Object)theEnd2Element.getActivityId());
        Assert.assertTrue((theEnd2Element.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testForkReplaceBy() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)2L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(0);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(1);
        Assert.assertEquals((Object)"theService3", (Object)theService3Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() == theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theService4").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)5L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService4Element = order.get(2);
        Assert.assertEquals((Object)"theService4", (Object)theService4Element.getActivityId());
        Assert.assertTrue((theService4Element.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService5Element = order.get(3);
        Assert.assertEquals((Object)"theService5", (Object)theService5Element.getActivityId());
        Assert.assertTrue((theService5Element.getSequenceCounter() > theService4Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(4);
        Assert.assertEquals((Object)"theEnd2", (Object)theEnd2Element.getActivityId());
        Assert.assertTrue((theEnd2Element.getSequenceCounter() > theService5Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theService2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)7L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(5);
        Assert.assertEquals((Object)"theService2", (Object)theService2Element.getActivityId());
        Assert.assertTrue((theService2Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService2Element.getSequenceCounter() > theEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(6);
        Assert.assertEquals((Object)"theEnd1", (Object)theEnd1Element.getActivityId());
        Assert.assertTrue((theEnd1Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testForkReplaceBy.bpmn20.xml"})
    @Test
    public void testForkReplaceByAnotherExecutionOrder() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)2L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(0);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(1);
        Assert.assertEquals((Object)"theService3", (Object)theService3Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() == theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theService2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)4L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(2);
        Assert.assertEquals((Object)"theService2", (Object)theService2Element.getActivityId());
        Assert.assertTrue((theService2Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(3);
        Assert.assertEquals((Object)"theEnd1", (Object)theEnd1Element.getActivityId());
        Assert.assertTrue((theEnd1Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theService4").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)7L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService4Element = order.get(4);
        Assert.assertEquals((Object)"theService4", (Object)theService4Element.getActivityId());
        Assert.assertTrue((theService4Element.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService4Element.getSequenceCounter() > theEnd1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService5Element = order.get(5);
        Assert.assertEquals((Object)"theService5", (Object)theService5Element.getActivityId());
        Assert.assertTrue((theService5Element.getSequenceCounter() > theService4Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(6);
        Assert.assertEquals((Object)"theEnd2", (Object)theEnd2Element.getActivityId());
        Assert.assertTrue((theEnd2Element.getSequenceCounter() > theService5Element.getSequenceCounter() ? 1 : 0) != 0);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testForkReplaceByThreeBranches() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)3L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(0);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(1);
        Assert.assertEquals((Object)"theService3", (Object)theService3Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService6Element = order.get(2);
        Assert.assertEquals((Object)"theService6", (Object)theService6Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() == theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService3Element.getSequenceCounter() == theService6Element.getSequenceCounter() ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theService2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)5L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(3);
        Assert.assertEquals((Object)"theService2", (Object)theService2Element.getActivityId());
        Assert.assertTrue((theService2Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(4);
        Assert.assertEquals((Object)"theEnd1", (Object)theEnd1Element.getActivityId());
        Assert.assertTrue((theEnd1Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theService4").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)8L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService4Element = order.get(5);
        Assert.assertEquals((Object)"theService4", (Object)theService4Element.getActivityId());
        Assert.assertTrue((theService4Element.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService5Element = order.get(6);
        Assert.assertEquals((Object)"theService5", (Object)theService5Element.getActivityId());
        Assert.assertTrue((theService5Element.getSequenceCounter() > theService4Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(7);
        Assert.assertEquals((Object)"theEnd2", (Object)theEnd2Element.getActivityId());
        Assert.assertTrue((theEnd2Element.getSequenceCounter() > theService5Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theService7").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)12L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService7Element = order.get(8);
        Assert.assertEquals((Object)"theService7", (Object)theService7Element.getActivityId());
        Assert.assertTrue((theService7Element.getSequenceCounter() > theService6Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService7Element.getSequenceCounter() > theEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService8Element = order.get(9);
        Assert.assertEquals((Object)"theService8", (Object)theService8Element.getActivityId());
        Assert.assertTrue((theService8Element.getSequenceCounter() > theService7Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService9Element = order.get(10);
        Assert.assertEquals((Object)"theService9", (Object)theService9Element.getActivityId());
        Assert.assertTrue((theService9Element.getSequenceCounter() > theService8Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd3Element = order.get(11);
        Assert.assertEquals((Object)"theEnd3", (Object)theEnd3Element.getActivityId());
        Assert.assertTrue((theEnd3Element.getSequenceCounter() > theService9Element.getSequenceCounter() ? 1 : 0) != 0);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testForkAndJoinSameSequenceLength() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)9L, (long)order.size());
        long lastSequenceCounter = 0L;
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        Assert.assertEquals((Object)"theStart", (Object)theStartElement.getActivityId());
        Assert.assertTrue((theStartElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theStartElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theForkElement = order.get(1);
        Assert.assertEquals((Object)"theService", (Object)theForkElement.getActivityId());
        Assert.assertTrue((theForkElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceElement = order.get(2);
        Assert.assertEquals((Object)"fork", (Object)theServiceElement.getActivityId());
        Assert.assertTrue((theServiceElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theServiceElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(3);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService1Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin1Element = order.get(4);
        Assert.assertEquals((Object)"join", (Object)theJoin1Element.getActivityId());
        Assert.assertTrue((theJoin1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(5);
        Assert.assertEquals((Object)"theService2", (Object)theService2Element.getActivityId());
        Assert.assertTrue((theService2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService2Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin2Element = order.get(6);
        Assert.assertEquals((Object)"join", (Object)theJoin2Element.getActivityId());
        Assert.assertTrue((theJoin2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(7);
        Assert.assertEquals((Object)"theService3", (Object)theService3Element.getActivityId());
        Assert.assertTrue((theService3Element.getSequenceCounter() > theJoin1Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService3Element.getSequenceCounter() > theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        lastSequenceCounter = theService3Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theEndElement = order.get(8);
        Assert.assertEquals((Object)"theEnd", (Object)theEndElement.getActivityId());
        Assert.assertTrue((theEndElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testForkAndJoinDifferentSequenceLength() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)10L, (long)order.size());
        long lastSequenceCounter = 0L;
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        Assert.assertEquals((Object)"theStart", (Object)theStartElement.getActivityId());
        Assert.assertTrue((theStartElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theStartElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theForkElement = order.get(1);
        Assert.assertEquals((Object)"theService", (Object)theForkElement.getActivityId());
        Assert.assertTrue((theForkElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceElement = order.get(2);
        Assert.assertEquals((Object)"fork", (Object)theServiceElement.getActivityId());
        Assert.assertTrue((theServiceElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theServiceElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(3);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService1Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin1Element = order.get(4);
        Assert.assertEquals((Object)"join", (Object)theJoin1Element.getActivityId());
        Assert.assertTrue((theJoin1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(5);
        Assert.assertEquals((Object)"theService2", (Object)theService2Element.getActivityId());
        Assert.assertTrue((theService2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService2Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(6);
        Assert.assertEquals((Object)"theService3", (Object)theService3Element.getActivityId());
        Assert.assertTrue((theService3Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService3Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin2Element = order.get(7);
        Assert.assertEquals((Object)"join", (Object)theJoin2Element.getActivityId());
        Assert.assertTrue((theJoin2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        Assert.assertFalse((theJoin1Element.getSequenceCounter() == theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService4Element = order.get(8);
        Assert.assertEquals((Object)"theService4", (Object)theService4Element.getActivityId());
        Assert.assertTrue((theService4Element.getSequenceCounter() > theJoin1Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService4Element.getSequenceCounter() > theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        lastSequenceCounter = theService4Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theEndElement = order.get(9);
        Assert.assertEquals((Object)"theEnd", (Object)theEndElement.getActivityId());
        Assert.assertTrue((theEndElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testForkAndJoinThreeBranchesDifferentSequenceLength() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)4L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin1Element = order.get(0);
        Assert.assertEquals((Object)"join", (Object)theJoin1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin2Element = order.get(1);
        Assert.assertEquals((Object)"join", (Object)theJoin2Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin3Element = order.get(2);
        Assert.assertEquals((Object)"join", (Object)theJoin3Element.getActivityId());
        Assert.assertFalse((theJoin1Element.getSequenceCounter() == theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertFalse((theJoin2Element.getSequenceCounter() == theJoin3Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertFalse((theJoin3Element.getSequenceCounter() == theJoin1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService7Element = order.get(3);
        Assert.assertEquals((Object)"theService7", (Object)theService7Element.getActivityId());
        Assert.assertTrue((theService7Element.getSequenceCounter() > theJoin1Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService7Element.getSequenceCounter() > theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService7Element.getSequenceCounter() > theJoin3Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testSequenceInsideSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "subProcess", "innerStart", "innerService", "innerEnd", "theService2", "theEnd");
    }

    @Deployment
    @Test
    public void testForkSameSequenceLengthInsideSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)3L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap innerEnd1Element = order.get(0);
        Assert.assertEquals((Object)"innerEnd1", (Object)innerEnd1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap innerEnd2Element = order.get(1);
        Assert.assertEquals((Object)"innerEnd2", (Object)innerEnd2Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(2);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() > innerEnd1Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService1Element.getSequenceCounter() > innerEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testForkDifferentSequenceLengthInsideSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)3L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap innerEnd1Element = order.get(0);
        Assert.assertEquals((Object)"innerEnd1", (Object)innerEnd1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap innerEnd2Element = order.get(1);
        Assert.assertEquals((Object)"innerEnd2", (Object)innerEnd2Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(2);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() > innerEnd1Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService1Element.getSequenceCounter() > innerEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testSequentialMultiInstance() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theService2", "theService2", "theService3", "theEnd");
    }

    @Deployment
    @Test
    public void testParallelMultiInstance() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)6L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        Assert.assertEquals((Object)"theStart", (Object)theStartElement.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(1);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        Assert.assertTrue((theService1Element.getSequenceCounter() > theStartElement.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService21Element = order.get(2);
        Assert.assertEquals((Object)"theService2", (Object)theService21Element.getActivityId());
        Assert.assertTrue((theService21Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService22Element = order.get(3);
        Assert.assertEquals((Object)"theService2", (Object)theService22Element.getActivityId());
        Assert.assertTrue((theService22Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(4);
        Assert.assertEquals((Object)"theService3", (Object)theService3Element.getActivityId());
        Assert.assertTrue((theService3Element.getSequenceCounter() > theService21Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertTrue((theService3Element.getSequenceCounter() > theService22Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEndElement = order.get(5);
        Assert.assertEquals((Object)"theEnd", (Object)theEndElement.getActivityId());
        Assert.assertTrue((theEndElement.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testLoop() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "join", "theScript", "fork", "join", "theScript", "fork", "theService2", "theEnd");
    }

    @Deployment
    @Test
    public void testInterruptingBoundaryEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theTask");
        this.runtimeService.correlateMessage("newMessage");
        this.testRule.assertProcessEnded(processInstanceId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theTask", "messageBoundary", "theServiceAfterMessage", "theEnd2");
    }

    @Deployment
    @Test
    public void testNonInterruptingBoundaryEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theTask");
        this.runtimeService.correlateMessage("newMessage");
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)6L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(1);
        Assert.assertEquals((Object)"theService1", (Object)theService1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theTaskElement = order.get(2);
        Assert.assertEquals((Object)"theTask", (Object)theTaskElement.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap messageBoundaryElement = order.get(3);
        Assert.assertEquals((Object)"messageBoundary", (Object)messageBoundaryElement.getActivityId());
        Assert.assertTrue((messageBoundaryElement.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        Assert.assertFalse((messageBoundaryElement.getSequenceCounter() > theTaskElement.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceAfterMessageElement = order.get(4);
        Assert.assertEquals((Object)"theServiceAfterMessage", (Object)theServiceAfterMessageElement.getActivityId());
        Assert.assertTrue((theServiceAfterMessageElement.getSequenceCounter() > messageBoundaryElement.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(5);
        Assert.assertEquals((Object)"theEnd2", (Object)theEnd2Element.getActivityId());
        Assert.assertTrue((theEnd2Element.getSequenceCounter() > theServiceAfterMessageElement.getSequenceCounter() ? 1 : 0) != 0);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.assertProcessEnded(processInstanceId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        Assert.assertEquals((long)7L, (long)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(6);
        Assert.assertEquals((Object)"theEnd1", (Object)theEnd1Element.getActivityId());
        Assert.assertTrue((theEnd1Element.getSequenceCounter() > theEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    protected void verifyOrder(List<ExecutionOrderListener.ActivitySequenceCounterMap> actualOrder, String ... expectedOrder) {
        Assert.assertEquals((long)expectedOrder.length, (long)actualOrder.size());
        long lastActualSequenceCounter = 0L;
        for (int i = 0; i < expectedOrder.length; ++i) {
            ExecutionOrderListener.ActivitySequenceCounterMap actual = actualOrder.get(i);
            String actualActivityId = actual.getActivityId();
            String expectedActivityId = expectedOrder[i];
            Assert.assertEquals((Object)actualActivityId, (Object)expectedActivityId);
            long actualSequenceCounter = actual.getSequenceCounter();
            Assert.assertTrue((actualSequenceCounter > lastActualSequenceCounter ? 1 : 0) != 0);
            lastActualSequenceCounter = actualSequenceCounter;
        }
    }
}

