/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.entity;

import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.impl.util.StringUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class JobEntityTest
extends PluggableProcessEngineTest {
    @Test
    public void testInsertJobWithExceptionMessage() {
        String fittingThreeByteMessage = this.repeatCharacter("\u9faf", StringUtil.DB_MAX_STRING_LENGTH);
        MessageEntity threeByteJobEntity = new MessageEntity();
        threeByteJobEntity.setExceptionMessage(fittingThreeByteMessage);
        this.insertJob((JobEntity)threeByteJobEntity);
        this.deleteJob((JobEntity)threeByteJobEntity);
    }

    @Test
    public void testJobExceptionMessageCutoff() {
        MessageEntity threeByteJobEntity = new MessageEntity();
        String message = this.repeatCharacter("a", StringUtil.DB_MAX_STRING_LENGTH * 2);
        threeByteJobEntity.setExceptionMessage(message);
        Assert.assertEquals((long)StringUtil.DB_MAX_STRING_LENGTH, (long)threeByteJobEntity.getExceptionMessage().length());
    }

    protected void insertJob(final JobEntity jobEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getJobManager().insert((DbEntity)jobEntity);
                return null;
            }
        });
    }

    protected void deleteJob(final JobEntity jobEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getJobManager().delete((DbEntity)jobEntity);
                return null;
            }
        });
    }

    protected String repeatCharacter(String encodedCharacter, int numCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numCharacters; ++i) {
            sb.append(encodedCharacter);
        }
        return sb.toString();
    }

    @Deployment
    @Test
    public void testLongProcessDefinitionKey() {
        String key = "myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((Object)key, (Object)job.getProcessDefinitionKey());
    }
}

