/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.identity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.identity.PasswordPolicy;
import org.eximeebpms.bpm.engine.identity.PasswordPolicyResult;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.identity.DefaultPasswordPolicyImpl;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PasswordPolicyUserDataTest {
    public static final String CANDIDATE_PASSWORD = "mypassword";
    @Rule
    public ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected IdentityService identityService;

    @Before
    public void init() {
        this.engineRule.getProcessEngineConfiguration().setEnablePasswordPolicy(true).setPasswordPolicy((PasswordPolicy)new DefaultPasswordPolicyImpl());
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void reset() {
        this.engineRule.getProcessEngineConfiguration().setEnablePasswordPolicy(false).setPasswordPolicy(null);
    }

    @Test
    public void shouldViolateRule() {
        String attributeValue = CANDIDATE_PASSWORD;
        Map<String, PasswordPolicyResult> results = this.getResultsForAttributes(attributeValue);
        this.assertRuleViolated(results);
    }

    @Test
    public void shouldFulfillRule() {
        String attributeValue = "another value";
        Map<String, PasswordPolicyResult> results = this.getResultsForAttributes(attributeValue);
        this.assertRuleFulfilled(results);
    }

    @Test
    public void shouldViolateRuleOnIgnoreCaseAttributeValue() {
        String attributeValue = "MYPASSWORD";
        Map<String, PasswordPolicyResult> results = this.getResultsForAttributes(attributeValue);
        this.assertRuleViolated(results);
    }

    @Test
    public void shouldFulfillRuleOnEmptyAttributeValue() {
        String attributeValue = "";
        Map<String, PasswordPolicyResult> results = this.getResultsForAttributes(attributeValue);
        this.assertRuleFulfilled(results);
    }

    @Test
    public void shouldFulfillRuleOnNullAttributeValue() {
        String attributeValue = null;
        Map<String, PasswordPolicyResult> results = this.getResultsForAttributes(attributeValue);
        this.assertRuleFulfilled(results);
    }

    public Map<String, PasswordPolicyResult> getResultsForAttributes(String attrValue) {
        HashMap<String, PasswordPolicyResult> results = new HashMap<String, PasswordPolicyResult>();
        List<Method> methods = Arrays.asList(User.class.getMethods());
        methods.forEach(method -> {
            String methodName = method.getName();
            if (methodName.startsWith("set") && !methodName.equals("setPassword")) {
                User user = this.identityService.newUser("");
                try {
                    method.invoke((Object)user, attrValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Assert.fail((String)e.getMessage());
                }
                PasswordPolicyResult passwordPolicyResult = this.identityService.checkPasswordAgainstPolicy(CANDIDATE_PASSWORD, user);
                results.put(methodName, passwordPolicyResult);
            }
        });
        return results;
    }

    protected void assertRuleViolated(Map<String, PasswordPolicyResult> results) {
        results.forEach((methodName, result) -> {
            try {
                Assertions.assertThat((List)result.getViolatedRules()).extracting("placeholder").contains(new Object[]{"PASSWORD_POLICY_USER_DATA"});
            }
            catch (AssertionError e) {
                Assert.fail((String)("Rule not violated with " + methodName + ":" + ((Throwable)((Object)e)).getMessage()));
            }
        });
    }

    protected void assertRuleFulfilled(Map<String, PasswordPolicyResult> results) {
        results.forEach((methodName, result) -> {
            try {
                Assertions.assertThat((List)result.getFulfilledRules()).extracting("placeholder").contains(new Object[]{"PASSWORD_POLICY_USER_DATA"});
            }
            catch (AssertionError e) {
                Assert.fail((String)("Rule not fulfilled with " + methodName + ":" + ((Throwable)((Object)e)).getMessage()));
            }
        });
    }
}

