/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.pvm;

import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.eximeebpms.bpm.engine.impl.pvm.PvmExecution;
import org.eximeebpms.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.eximeebpms.bpm.engine.impl.pvm.PvmProcessInstance;
import org.eximeebpms.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.eximeebpms.bpm.engine.test.standalone.pvm.ActivityInstanceVerification;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.Automatic;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.EmbeddedSubProcess;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.End;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.ParallelGateway;
import org.eximeebpms.bpm.engine.test.standalone.pvm.activities.WaitState;
import org.junit.Test;

public class PvmActivityInstanceCompleteTest {
    @Test
    public void testSingleEnd() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("end", (ExecutionListener)verifier).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        verifier.assertNonCompletingActivityInstance("start", 1);
        verifier.assertIsCompletingActivityInstance("end", 1);
    }

    @Test
    public void testTwoEnds() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("end", (ExecutionListener)verifier).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).executionListener("end", (ExecutionListener)verifier).transition("end1").transition("end2").endActivity().createActivity("end1").behavior((ActivityBehavior)new End()).executionListener("end", (ExecutionListener)verifier).endActivity().createActivity("end2").behavior((ActivityBehavior)new End()).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        verifier.assertNonCompletingActivityInstance("start", 1);
        verifier.assertNonCompletingActivityInstance("fork", 1);
        verifier.assertIsCompletingActivityInstance("end1", 1);
        verifier.assertIsCompletingActivityInstance("end2", 1);
    }

    @Test
    public void testSingleEndAfterParallelJoin() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("end", (ExecutionListener)verifier).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).executionListener("end", (ExecutionListener)verifier).transition("a1").transition("a2").endActivity().createActivity("a1").behavior((ActivityBehavior)new Automatic()).executionListener("end", (ExecutionListener)verifier).transition("join").endActivity().createActivity("a2").behavior((ActivityBehavior)new Automatic()).executionListener("end", (ExecutionListener)verifier).transition("join").endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).executionListener("end", (ExecutionListener)verifier).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        verifier.assertNonCompletingActivityInstance("start", 1);
        verifier.assertNonCompletingActivityInstance("fork", 1);
        verifier.assertNonCompletingActivityInstance("a1", 1);
        verifier.assertNonCompletingActivityInstance("a2", 1);
        verifier.assertNonCompletingActivityInstance("join", 2);
        verifier.assertIsCompletingActivityInstance("end", 1);
    }

    @Test
    public void testSimpleSubProcess() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("end", (ExecutionListener)verifier).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("end", (ExecutionListener)verifier).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).executionListener("end", (ExecutionListener)verifier).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).executionListener("end", (ExecutionListener)verifier).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        verifier.assertNonCompletingActivityInstance("start", 1);
        verifier.assertNonCompletingActivityInstance("embeddedsubprocess", 1);
        verifier.assertNonCompletingActivityInstance("startInside", 1);
        verifier.assertIsCompletingActivityInstance("endInside", 1);
        verifier.assertIsCompletingActivityInstance("end", 1);
    }

    @Test
    public void testBoundaryEvent() {
        ActivityInstanceVerification verifier = new ActivityInstanceVerification();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("end", (ExecutionListener)verifier).transition("userTask").endActivity().createActivity("userTask").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).executionListener("end", (ExecutionListener)verifier).transition("end1").endActivity().createActivity("timer").behavior((ActivityBehavior)new WaitState()).executionListener("end", (ExecutionListener)verifier).attachedTo("userTask", true).transition("end2").endActivity().createActivity("end1").behavior((ActivityBehavior)new End()).executionListener("end", (ExecutionListener)verifier).endActivity().createActivity("end2").behavior((ActivityBehavior)new End()).executionListener("end", (ExecutionListener)verifier).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmExecution userTaskExecution = processInstance.findExecution("userTask");
        ((PvmExecutionImpl)userTaskExecution).executeActivity(processDefinition.findActivity("timer"));
        PvmExecution timerExecution = processInstance.findExecution("timer");
        timerExecution.signal(null, null);
        verifier.assertNonCompletingActivityInstance("start", 1);
        verifier.assertNonCompletingActivityInstance("userTask", 1);
        verifier.assertIsCompletingActivityInstance("end2", 1);
    }
}

