/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.scripting;

import java.util.concurrent.Callable;
import javax.script.ScriptEngine;
import org.eximeebpms.bpm.application.ProcessApplicationInterface;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.application.impl.EmbeddedProcessApplication;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.eximeebpms.bpm.engine.repository.ProcessApplicationDeployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ScriptEngineCachingTest
extends PluggableProcessEngineTest {
    protected static final String PROCESS_PATH = "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String SCRIPT_LANGUAGE = "groovy";

    @Test
    public void testGlobalCachingOfScriptEngine() {
        ScriptEngine engine = this.getScriptEngine(SCRIPT_LANGUAGE);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((Object)engine, (Object)this.getScriptEngine(SCRIPT_LANGUAGE));
    }

    @Test
    public void testGlobalDisableCachingOfScriptEngine() {
        this.processEngineConfiguration.setEnableScriptEngineCaching(false);
        this.getScriptingEngines().setEnableScriptEngineCaching(false);
        ScriptEngine engine = this.getScriptEngine(SCRIPT_LANGUAGE);
        Assert.assertNotNull((Object)engine);
        Assert.assertFalse((boolean)engine.equals(this.getScriptEngine(SCRIPT_LANGUAGE)));
        this.processEngineConfiguration.setEnableScriptEngineCaching(true);
        this.getScriptingEngines().setEnableScriptEngineCaching(true);
    }

    @Test
    public void testCachingOfScriptEngineInProcessApplication() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ScriptEngine engine = processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, true);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((Object)engine, (Object)processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, true));
    }

    @Test
    public void testDisableCachingOfScriptEngineInProcessApplication() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ScriptEngine engine = processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, false);
        Assert.assertNotNull((Object)engine);
        Assert.assertFalse((boolean)engine.equals(processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, false)));
    }

    @Test
    public void testFetchScriptEngineFromPaEnableCaching() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(processApplication.getReference()).addClasspathResource(PROCESS_PATH).deploy();
        ScriptEngine engine = this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((Object)engine, (Object)this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication));
        Assert.assertEquals((Object)engine, (Object)processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, true));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testFetchScriptEngineFromPaDisableCaching() {
        this.processEngineConfiguration.setEnableScriptEngineCaching(false);
        this.getScriptingEngines().setEnableScriptEngineCaching(false);
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(processApplication.getReference()).addClasspathResource(PROCESS_PATH).deploy();
        ScriptEngine engine = this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication);
        Assert.assertNotNull((Object)engine);
        Assert.assertFalse((boolean)engine.equals(this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication)));
        Assert.assertFalse((boolean)engine.equals(processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, false)));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.processEngineConfiguration.setEnableScriptEngineCaching(true);
        this.getScriptingEngines().setEnableScriptEngineCaching(true);
    }

    @Test
    public void testDisableFetchScriptEngineFromProcessApplication() {
        this.processEngineConfiguration.setEnableFetchScriptEngineFromProcessApplication(false);
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(processApplication.getReference()).addClasspathResource(PROCESS_PATH).deploy();
        ScriptEngine engine = this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((Object)engine, (Object)this.getScriptEngineFromPa(SCRIPT_LANGUAGE, (ProcessApplicationInterface)processApplication));
        Assert.assertFalse((boolean)engine.equals(processApplication.getScriptEngineForName(SCRIPT_LANGUAGE, true)));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.processEngineConfiguration.setEnableFetchScriptEngineFromProcessApplication(true);
    }

    protected ScriptingEngines getScriptingEngines() {
        return this.processEngineConfiguration.getScriptingEngines();
    }

    protected ScriptEngine getScriptEngine(final String name) {
        final ScriptingEngines scriptingEngines = this.getScriptingEngines();
        return (ScriptEngine)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<ScriptEngine>(){

            public ScriptEngine execute(CommandContext commandContext) {
                return scriptingEngines.getScriptEngineForLanguage(name);
            }
        });
    }

    protected ScriptEngine getScriptEngineFromPa(final String name, final ProcessApplicationInterface processApplication) {
        return (ScriptEngine)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<ScriptEngine>(){

            public ScriptEngine execute(CommandContext commandContext) {
                return (ScriptEngine)Context.executeWithinProcessApplication((Callable)new Callable<ScriptEngine>(){

                    @Override
                    public ScriptEngine call() throws Exception {
                        return ScriptEngineCachingTest.this.getScriptEngine(name);
                    }
                }, (ProcessApplicationReference)processApplication.getReference());
            }
        });
    }
}

