/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.scripting;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.application.ProcessApplicationInterface;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.application.impl.EmbeddedProcessApplication;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.scripting.engine.DefaultScriptEngineResolver;
import org.eximeebpms.bpm.engine.impl.scripting.engine.ScriptEngineResolver;
import org.eximeebpms.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class ScriptEngineNameJavaScriptTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected String defaultJsSciptEngineName;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.defaultJsSciptEngineName = this.processEngineConfiguration.getScriptEngineNameJavaScript();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setScriptEngineNameJavaScript(this.defaultJsSciptEngineName);
    }

    @Test
    public void shouldFindDefaultEngineForJavaScript() {
        ScriptEngine scriptEngine = this.getScriptEngine("javascript");
        Assertions.assertThat((Object)scriptEngine).isNotNull();
        Assertions.assertThat((String)scriptEngine.getFactory().getEngineName()).isEqualTo((Object)"Graal.js");
    }

    @Test
    public void shouldFindDefaultEngineForEcmaScript() {
        ScriptEngine scriptEngine = this.getScriptEngine("ecmascript");
        Assertions.assertThat((Object)scriptEngine).isNotNull();
        Assertions.assertThat((String)scriptEngine.getFactory().getEngineName()).isEqualTo((Object)"Graal.js");
    }

    @Test
    public void shouldFindDefaultEngineForJavaScriptInPa() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ScriptEngine scriptEngine = this.getScriptEngineFromPa("javascript", (ProcessApplicationInterface)processApplication);
        Assertions.assertThat((Object)scriptEngine).isNotNull();
        Assertions.assertThat((String)scriptEngine.getFactory().getEngineName()).isEqualTo((Object)"Graal.js");
    }

    @Test
    public void shouldFindDefaultEngineForEcmaScriptInPa() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ScriptEngine scriptEngine = this.getScriptEngineFromPa("ecmascript", (ProcessApplicationInterface)processApplication);
        Assertions.assertThat((Object)scriptEngine).isNotNull();
        Assertions.assertThat((String)scriptEngine.getFactory().getEngineName()).isEqualTo((Object)"Graal.js");
    }

    @Test
    public void shouldFailIfDefinedEngineCannotBeFound() {
        this.processEngineConfiguration.setScriptEngineNameJavaScript("undefined");
        Assertions.assertThatThrownBy(() -> this.getScriptEngine("javascript")).isInstanceOf(NullValueException.class);
    }

    @Test
    public void shouldFailIfDefinedEngineCannotBeFoundInPa() {
        this.processEngineConfiguration.setScriptEngineNameJavaScript("undefined");
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        Assertions.assertThatThrownBy(() -> this.getScriptEngineFromPa("javascript", (ProcessApplicationInterface)processApplication)).isInstanceOf(NullValueException.class);
    }

    @Test
    public void shouldFallbackToAnyEngineForJavaScriptIfDefaultUnavailable() {
        ScriptEngineManager mockScriptEngineManager = (ScriptEngineManager)Mockito.mock(ScriptEngineManager.class);
        ScriptEngine mockScriptEngine = (ScriptEngine)Mockito.mock(ScriptEngine.class);
        ScriptEngineFactory mockScriptEngineFactory = (ScriptEngineFactory)Mockito.mock(ScriptEngineFactory.class);
        ScriptingEngines scriptingEngines = new ScriptingEngines((ScriptEngineResolver)new DefaultScriptEngineResolver(mockScriptEngineManager));
        Mockito.when((Object)mockScriptEngineManager.getEngineByName("Graal.js")).thenReturn(null);
        Mockito.when((Object)mockScriptEngineManager.getEngineByName("javascript")).thenReturn((Object)mockScriptEngine);
        Mockito.when((Object)mockScriptEngine.getFactory()).thenReturn((Object)mockScriptEngineFactory);
        Mockito.when((Object)mockScriptEngineFactory.getEngineName()).thenReturn((Object)"foo");
        ScriptEngine scriptEngine = (ScriptEngine)this.processEngineConfiguration.getCommandExecutorTxRequired().execute(c -> scriptingEngines.getScriptEngineForLanguage("javascript"));
        Assertions.assertThat((Object)scriptEngine).isEqualTo((Object)mockScriptEngine);
    }

    protected ScriptingEngines getScriptingEngines() {
        return this.processEngineConfiguration.getScriptingEngines();
    }

    protected ScriptEngine getScriptEngine(String name) {
        ScriptingEngines scriptingEngines = this.getScriptingEngines();
        return (ScriptEngine)this.processEngineConfiguration.getCommandExecutorTxRequired().execute(c -> scriptingEngines.getScriptEngineForLanguage(name));
    }

    protected ScriptEngine getScriptEngineFromPa(String name, ProcessApplicationInterface processApplication) {
        return (ScriptEngine)this.processEngineConfiguration.getCommandExecutorTxRequired().execute(c -> (ScriptEngine)Context.executeWithinProcessApplication(() -> this.getScriptEngine(name), (ProcessApplicationReference)processApplication.getReference()));
    }
}

