/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.eximeebpms.bpm.engine.delegate.Expression;
import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.impl.calendar.DateTimeUtil;
import org.eximeebpms.bpm.engine.impl.el.ExpressionManager;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.task.TaskDecorator;
import org.eximeebpms.bpm.engine.impl.task.TaskDefinition;
import org.eximeebpms.bpm.engine.task.IdentityLink;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskDecoratorTest
extends PluggableProcessEngineTest {
    protected TaskEntity task;
    protected TaskDefinition taskDefinition;
    protected TaskDecorator taskDecorator;
    protected ExpressionManager expressionManager;

    @Before
    public void setUp() {
        this.task = (TaskEntity)this.taskService.newTask();
        this.taskService.saveTask((Task)this.task);
        this.expressionManager = this.processEngineConfiguration.getExpressionManager();
        this.taskDefinition = new TaskDefinition(null);
        this.taskDecorator = new TaskDecorator(this.taskDefinition, this.expressionManager);
    }

    @After
    public void tearDown() throws InterruptedException {
        this.taskService.deleteTask(this.task.getId(), true);
    }

    protected void decorate(TaskEntity task, TaskDecorator decorator) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new DecorateTaskCommand(task, decorator));
    }

    @Test
    public void testDecorateName() {
        String aTaskName = "A Task Name";
        org.eximeebpms.bpm.engine.impl.el.Expression nameExpression = this.expressionManager.createExpression(aTaskName);
        this.taskDefinition.setNameExpression((Expression)nameExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)aTaskName, (Object)this.task.getName());
    }

    @Test
    public void testDecorateNameFromVariable() {
        String aTaskName = "A Task Name";
        this.taskService.setVariable(this.task.getId(), "taskName", (Object)aTaskName);
        org.eximeebpms.bpm.engine.impl.el.Expression nameExpression = this.expressionManager.createExpression("${taskName}");
        this.taskDefinition.setNameExpression((Expression)nameExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)aTaskName, (Object)this.task.getName());
    }

    @Test
    public void testDecorateDescription() {
        String aDescription = "This is a Task";
        org.eximeebpms.bpm.engine.impl.el.Expression descriptionExpression = this.expressionManager.createExpression(aDescription);
        this.taskDefinition.setDescriptionExpression((Expression)descriptionExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)aDescription, (Object)this.task.getDescription());
    }

    @Test
    public void testDecorateDescriptionFromVariable() {
        String aDescription = "This is a Task";
        this.taskService.setVariable(this.task.getId(), "description", (Object)aDescription);
        org.eximeebpms.bpm.engine.impl.el.Expression descriptionExpression = this.expressionManager.createExpression("${description}");
        this.taskDefinition.setDescriptionExpression((Expression)descriptionExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)aDescription, (Object)this.task.getDescription());
    }

    @Test
    public void testDecorateDueDate() {
        String aDueDate = "2014-06-01";
        Date dueDate = DateTimeUtil.parseDate((String)aDueDate);
        org.eximeebpms.bpm.engine.impl.el.Expression dueDateExpression = this.expressionManager.createExpression(aDueDate);
        this.taskDefinition.setDueDateExpression((Expression)dueDateExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)dueDate, (Object)this.task.getDueDate());
    }

    @Test
    public void testDecorateDueDateFromVariable() {
        String aDueDate = "2014-06-01";
        Date dueDate = DateTimeUtil.parseDate((String)aDueDate);
        this.taskService.setVariable(this.task.getId(), "dueDate", (Object)dueDate);
        org.eximeebpms.bpm.engine.impl.el.Expression dueDateExpression = this.expressionManager.createExpression("${dueDate}");
        this.taskDefinition.setDueDateExpression((Expression)dueDateExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)dueDate, (Object)this.task.getDueDate());
    }

    @Test
    public void testDecorateFollowUpDate() {
        String aFollowUpDate = "2014-06-01";
        Date followUpDate = DateTimeUtil.parseDate((String)aFollowUpDate);
        org.eximeebpms.bpm.engine.impl.el.Expression followUpDateExpression = this.expressionManager.createExpression(aFollowUpDate);
        this.taskDefinition.setFollowUpDateExpression((Expression)followUpDateExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)followUpDate, (Object)this.task.getFollowUpDate());
    }

    @Test
    public void testDecorateFollowUpDateFromVariable() {
        String aFollowUpDateDate = "2014-06-01";
        Date followUpDate = DateTimeUtil.parseDate((String)aFollowUpDateDate);
        this.taskService.setVariable(this.task.getId(), "followUpDate", (Object)followUpDate);
        org.eximeebpms.bpm.engine.impl.el.Expression followUpDateExpression = this.expressionManager.createExpression("${followUpDate}");
        this.taskDefinition.setFollowUpDateExpression((Expression)followUpDateExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)followUpDate, (Object)this.task.getFollowUpDate());
    }

    @Test
    public void testDecoratePriority() {
        String aPriority = "10";
        org.eximeebpms.bpm.engine.impl.el.Expression priorityExpression = this.expressionManager.createExpression(aPriority);
        this.taskDefinition.setPriorityExpression((Expression)priorityExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((long)Integer.parseInt(aPriority), (long)this.task.getPriority());
    }

    @Test
    public void testDecoratePriorityFromVariable() {
        int aPriority = 10;
        this.taskService.setVariable(this.task.getId(), "priority", (Object)aPriority);
        org.eximeebpms.bpm.engine.impl.el.Expression priorityExpression = this.expressionManager.createExpression("${priority}");
        this.taskDefinition.setPriorityExpression((Expression)priorityExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((long)aPriority, (long)this.task.getPriority());
    }

    @Test
    public void testDecorateAssignee() {
        String aAssignee = "john";
        org.eximeebpms.bpm.engine.impl.el.Expression assigneeExpression = this.expressionManager.createExpression(aAssignee);
        this.taskDefinition.setAssigneeExpression((Expression)assigneeExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)aAssignee, (Object)this.task.getAssignee());
    }

    @Test
    public void testDecorateAssigneeFromVariable() {
        String aAssignee = "john";
        this.taskService.setVariable(this.task.getId(), "assignee", (Object)aAssignee);
        org.eximeebpms.bpm.engine.impl.el.Expression assigneeExpression = this.expressionManager.createExpression("${assignee}");
        this.taskDefinition.setAssigneeExpression((Expression)assigneeExpression);
        this.decorate(this.task, this.taskDecorator);
        Assert.assertEquals((Object)aAssignee, (Object)this.task.getAssignee());
    }

    @Test
    public void testDecorateCandidateUsers() {
        ArrayList<String> aCandidateUserList = new ArrayList<String>();
        aCandidateUserList.add("john");
        aCandidateUserList.add("peter");
        aCandidateUserList.add("mary");
        for (String candidateUser : aCandidateUserList) {
            org.eximeebpms.bpm.engine.impl.el.Expression candidateUserExpression = this.expressionManager.createExpression(candidateUser);
            this.taskDefinition.addCandidateUserIdExpression((Expression)candidateUserExpression);
        }
        this.decorate(this.task, this.taskDecorator);
        Set candidates = this.task.getCandidates();
        Assert.assertEquals((long)3L, (long)candidates.size());
        for (IdentityLink identityLink : candidates) {
            String taskId = identityLink.getTaskId();
            Assert.assertEquals((Object)this.task.getId(), (Object)taskId);
            Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
            String userId = identityLink.getUserId();
            if ("john".equals(userId)) {
                Assert.assertEquals((Object)"john", (Object)userId);
                continue;
            }
            if ("peter".equals(userId)) {
                Assert.assertEquals((Object)"peter", (Object)userId);
                continue;
            }
            if ("mary".equals(userId)) {
                Assert.assertEquals((Object)"mary", (Object)userId);
                continue;
            }
            Assert.fail((String)("Unexpected user: " + userId));
        }
    }

    @Test
    public void testDecorateCandidateUsersFromVariable() {
        this.taskService.setVariable(this.task.getId(), "john", (Object)"john");
        this.taskService.setVariable(this.task.getId(), "peter", (Object)"peter");
        this.taskService.setVariable(this.task.getId(), "mary", (Object)"mary");
        ArrayList<String> aCandidateUserList = new ArrayList<String>();
        aCandidateUserList.add("${john}");
        aCandidateUserList.add("${peter}");
        aCandidateUserList.add("${mary}");
        for (String candidateUser : aCandidateUserList) {
            org.eximeebpms.bpm.engine.impl.el.Expression candidateUserExpression = this.expressionManager.createExpression(candidateUser);
            this.taskDefinition.addCandidateUserIdExpression((Expression)candidateUserExpression);
        }
        this.decorate(this.task, this.taskDecorator);
        Set candidates = this.task.getCandidates();
        Assert.assertEquals((long)3L, (long)candidates.size());
        for (IdentityLink identityLink : candidates) {
            String taskId = identityLink.getTaskId();
            Assert.assertEquals((Object)this.task.getId(), (Object)taskId);
            Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
            String userId = identityLink.getUserId();
            if ("john".equals(userId)) {
                Assert.assertEquals((Object)"john", (Object)userId);
                continue;
            }
            if ("peter".equals(userId)) {
                Assert.assertEquals((Object)"peter", (Object)userId);
                continue;
            }
            if ("mary".equals(userId)) {
                Assert.assertEquals((Object)"mary", (Object)userId);
                continue;
            }
            Assert.fail((String)("Unexpected user: " + userId));
        }
    }

    @Test
    public void testDecorateCandidateGroups() {
        ArrayList<String> aCandidateGroupList = new ArrayList<String>();
        aCandidateGroupList.add("management");
        aCandidateGroupList.add("accounting");
        aCandidateGroupList.add("backoffice");
        for (String candidateGroup : aCandidateGroupList) {
            org.eximeebpms.bpm.engine.impl.el.Expression candidateGroupExpression = this.expressionManager.createExpression(candidateGroup);
            this.taskDefinition.addCandidateGroupIdExpression((Expression)candidateGroupExpression);
        }
        this.decorate(this.task, this.taskDecorator);
        Set candidates = this.task.getCandidates();
        Assert.assertEquals((long)3L, (long)candidates.size());
        for (IdentityLink identityLink : candidates) {
            String taskId = identityLink.getTaskId();
            Assert.assertEquals((Object)this.task.getId(), (Object)taskId);
            Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
            String groupId = identityLink.getGroupId();
            if ("management".equals(groupId)) {
                Assert.assertEquals((Object)"management", (Object)groupId);
                continue;
            }
            if ("accounting".equals(groupId)) {
                Assert.assertEquals((Object)"accounting", (Object)groupId);
                continue;
            }
            if ("backoffice".equals(groupId)) {
                Assert.assertEquals((Object)"backoffice", (Object)groupId);
                continue;
            }
            Assert.fail((String)("Unexpected group: " + groupId));
        }
    }

    @Test
    public void testDecorateCandidateGroupsFromVariable() {
        this.taskService.setVariable(this.task.getId(), "management", (Object)"management");
        this.taskService.setVariable(this.task.getId(), "accounting", (Object)"accounting");
        this.taskService.setVariable(this.task.getId(), "backoffice", (Object)"backoffice");
        ArrayList<String> aCandidateGroupList = new ArrayList<String>();
        aCandidateGroupList.add("${management}");
        aCandidateGroupList.add("${accounting}");
        aCandidateGroupList.add("${backoffice}");
        for (String candidateGroup : aCandidateGroupList) {
            org.eximeebpms.bpm.engine.impl.el.Expression candidateGroupExpression = this.expressionManager.createExpression(candidateGroup);
            this.taskDefinition.addCandidateGroupIdExpression((Expression)candidateGroupExpression);
        }
        this.decorate(this.task, this.taskDecorator);
        Set candidates = this.task.getCandidates();
        Assert.assertEquals((long)3L, (long)candidates.size());
        for (IdentityLink identityLink : candidates) {
            String taskId = identityLink.getTaskId();
            Assert.assertEquals((Object)this.task.getId(), (Object)taskId);
            Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
            String groupId = identityLink.getGroupId();
            if ("management".equals(groupId)) {
                Assert.assertEquals((Object)"management", (Object)groupId);
                continue;
            }
            if ("accounting".equals(groupId)) {
                Assert.assertEquals((Object)"accounting", (Object)groupId);
                continue;
            }
            if ("backoffice".equals(groupId)) {
                Assert.assertEquals((Object)"backoffice", (Object)groupId);
                continue;
            }
            Assert.fail((String)("Unexpected group: " + groupId));
        }
    }

    protected class DecorateTaskCommand
    implements Command<Void> {
        protected TaskEntity task;
        protected TaskDecorator decorator;

        public DecorateTaskCommand(TaskEntity task, TaskDecorator decorator) {
            this.task = task;
            this.decorator = decorator;
        }

        public Void execute(CommandContext commandContext) {
            this.decorator.decorate(this.task, (VariableScope)this.task);
            return null;
        }
    }

    protected class DeleteTaskCommand
    implements Command<Void> {
        protected TaskEntity task;

        public DeleteTaskCommand(TaskEntity task) {
            this.task = task;
        }

        public Void execute(CommandContext commandContext) {
            commandContext.getTaskManager().deleteTask(this.task, null, true, false);
            return null;
        }
    }
}

