/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.util;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.util.CompareUtil;
import org.junit.Test;

public class CompareUtilTest {
    @Test
    public void testDateNotInAnAscendingOrder() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2015, 2, 15);
        Date first = calendar.getTime();
        calendar.set(2015, 7, 15);
        Date second = calendar.getTime();
        Object nullDate = null;
        Assertions.assertThat((boolean)CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{null, first, null, second})).isFalse();
        Assertions.assertThat((boolean)CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{null, first, null, first})).isFalse();
        Assertions.assertThat((boolean)CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{null, second, null, first})).isTrue();
        Assertions.assertThat((boolean)CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{nullDate, nullDate, nullDate})).isFalse();
        Assertions.assertThat((boolean)CompareUtil.areNotInAscendingOrder(Arrays.asList(first, second))).isFalse();
        Assertions.assertThat((boolean)CompareUtil.areNotInAscendingOrder(Arrays.asList(first, first))).isFalse();
        Assertions.assertThat((boolean)CompareUtil.areNotInAscendingOrder(Arrays.asList(second, first))).isTrue();
    }

    @Test
    public void testIsNotContainedIn() {
        String element = "test";
        Object[] values = new String[]{"test", "test1", "test2"};
        Object[] values2 = new String[]{"test1", "test2"};
        Object[] nullValues = null;
        Collection nullList = null;
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInArray((Object)element, (Object[])values)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInArray((Object)element, (Object[])values2)).isTrue();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInArray(null, (Object[])values)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInArray(null, nullValues)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInArray((Object)element, nullValues)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInList((Object)element, Arrays.asList(values))).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInList((Object)element, Arrays.asList(values2))).isTrue();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInList(null, Arrays.asList(values))).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInList(null, nullList)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsNotContainedInList((Object)element, nullList)).isFalse();
    }

    @Test
    public void testIsContainedIn() {
        String element = "test";
        Object[] values = new String[]{"test", "test1", "test2"};
        Object[] values2 = new String[]{"test1", "test2"};
        Object[] nullValues = null;
        Collection nullList = null;
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInArray((Object)element, (Object[])values)).isTrue();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInArray((Object)element, (Object[])values2)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInArray(null, (Object[])values)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInArray(null, nullValues)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInArray((Object)element, nullValues)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInList((Object)element, Arrays.asList(values))).isTrue();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInList((Object)element, Arrays.asList(values2))).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInList(null, Arrays.asList(values))).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInList(null, nullList)).isFalse();
        Assertions.assertThat((boolean)CompareUtil.elementIsContainedInList((Object)element, nullList)).isFalse();
    }
}

