/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.test.util.ExecutionTree;
import org.eximeebpms.bpm.engine.test.util.ExecutionTreeAssertion;
import org.junit.Assert;

public class ExecutionTreeStructureAssertion
implements ExecutionTreeAssertion {
    protected String expectedActivityId;
    protected Boolean expectedIsScope = true;
    protected Boolean expectedIsConcurrent = false;
    protected Boolean expectedIsEventScope = false;
    protected String expectedId;
    protected List<ExecutionTreeStructureAssertion> childAssertions = new ArrayList<ExecutionTreeStructureAssertion>();

    public void addChildAssertion(ExecutionTreeStructureAssertion childAssertion) {
        this.childAssertions.add(childAssertion);
    }

    public void setExpectedActivityId(String expectedActivityId) {
        this.expectedActivityId = expectedActivityId;
    }

    protected boolean matches(ExecutionTree tree) {
        String actualActivityId = tree.getActivityId();
        if (this.expectedActivityId == null && actualActivityId != null) {
            return false;
        }
        if (this.expectedActivityId != null && !this.expectedActivityId.equals(tree.getActivityId())) {
            return false;
        }
        if (this.expectedId != null && !this.expectedId.equals(tree.getId())) {
            return false;
        }
        if (this.expectedIsScope != null && !this.expectedIsScope.equals(tree.isScope())) {
            return false;
        }
        if (this.expectedIsConcurrent != null && !this.expectedIsConcurrent.equals(tree.isConcurrent())) {
            return false;
        }
        if (this.expectedIsEventScope != null && !this.expectedIsEventScope.equals(tree.isEventScope())) {
            return false;
        }
        if (tree.getExecutions().size() != this.childAssertions.size()) {
            return false;
        }
        ArrayList<ExecutionTreeStructureAssertion> unmatchedChildAssertions = new ArrayList<ExecutionTreeStructureAssertion>(this.childAssertions);
        block0: for (ExecutionTree child : tree.getExecutions()) {
            for (ExecutionTreeStructureAssertion childAssertion : unmatchedChildAssertions) {
                if (!childAssertion.matches(child)) continue;
                unmatchedChildAssertions.remove(childAssertion);
                continue block0;
            }
        }
        return unmatchedChildAssertions.isEmpty();
    }

    @Override
    public void assertExecution(ExecutionTree tree) {
        boolean matches = this.matches(tree);
        if (!matches) {
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("Expected tree: \n");
            ExecutionTreeStructureAssertion.describe(this, "", errorBuilder);
            errorBuilder.append("Actual tree: \n");
            errorBuilder.append(tree);
            Assert.fail((String)errorBuilder.toString());
        }
    }

    public static void describe(ExecutionTreeStructureAssertion assertion, String prefix, StringBuilder errorBuilder) {
        errorBuilder.append(prefix);
        errorBuilder.append(assertion);
        errorBuilder.append("\n");
        for (ExecutionTreeStructureAssertion child : assertion.childAssertions) {
            ExecutionTreeStructureAssertion.describe(child, prefix + "   ", errorBuilder);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[activityId=");
        sb.append(this.expectedActivityId);
        if (this.expectedId != null) {
            sb.append(", id=");
            sb.append(this.expectedId);
        }
        if (this.expectedIsScope != null) {
            sb.append(", isScope=");
            sb.append(this.expectedIsScope);
        }
        if (this.expectedIsConcurrent != null) {
            sb.append(", isConcurrent=");
            sb.append(this.expectedIsConcurrent);
        }
        if (this.expectedIsEventScope != null) {
            sb.append(", isEventScope=");
            sb.append(this.expectedIsEventScope);
        }
        sb.append("]");
        return sb.toString();
    }

    public void setExpectedIsScope(Boolean expectedIsScope) {
        this.expectedIsScope = expectedIsScope;
    }

    public void setExpectedIsConcurrent(Boolean expectedIsConcurrent) {
        this.expectedIsConcurrent = expectedIsConcurrent;
    }

    public void setExpectedIsEventScope(Boolean expectedIsEventScope) {
        this.expectedIsEventScope = expectedIsEventScope;
    }

    public void setExpectedId(String expectedId) {
        this.expectedId = expectedId;
    }
}

