/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.application.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eximeebpms.bpm.application.AbstractProcessApplication;
import org.eximeebpms.bpm.application.ProcessApplication;
import org.eximeebpms.bpm.application.impl.ProcessApplicationLogger;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;

public abstract class AbstractServletProcessApplicationDeployer {
    protected static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;

    protected void onStartUp(Set<Class<?>> c, String contextPath, Class<?> servletProcessApplicationClass, Consumer<String> processApplicationClassNameConsumer) throws Exception {
        if (c == null || c.isEmpty()) {
            return;
        }
        if (c.contains(ProcessApplication.class)) {
            c = new HashSet(c);
            c.remove(ProcessApplication.class);
        }
        if (c.size() > 1) {
            throw this.getServletException(LOG.multiplePasException(c, contextPath));
        }
        if (c.size() == 1) {
            Class<?> paClass = c.iterator().next();
            if (!AbstractProcessApplication.class.isAssignableFrom(paClass)) {
                throw this.getServletException(LOG.paWrongTypeException(paClass));
            }
            if (servletProcessApplicationClass.isAssignableFrom(paClass)) {
                LOG.detectedPa(paClass);
                processApplicationClassNameConsumer.accept(paClass.getName());
            }
        } else {
            LOG.servletDeployerNoPaFound(contextPath);
        }
    }

    protected abstract Exception getServletException(String var1);
}

