/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.application.impl;

import java.lang.ref.WeakReference;
import org.eximeebpms.bpm.application.AbstractProcessApplication;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.application.ProcessApplicationUnavailableException;
import org.eximeebpms.bpm.application.impl.ProcessApplicationLogger;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;

public class ProcessApplicationReferenceImpl
implements ProcessApplicationReference {
    private static ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;
    protected WeakReference<AbstractProcessApplication> processApplication;
    protected String name;

    public ProcessApplicationReferenceImpl(AbstractProcessApplication processApplication) {
        this.processApplication = new WeakReference<AbstractProcessApplication>(processApplication);
        this.name = processApplication.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractProcessApplication getProcessApplication() throws ProcessApplicationUnavailableException {
        AbstractProcessApplication application = (AbstractProcessApplication)this.processApplication.get();
        if (application == null) {
            throw LOG.processApplicationUnavailableException(this.name);
        }
        return application;
    }

    public void processEngineStopping(ProcessEngine processEngine) throws ProcessApplicationUnavailableException {
    }

    public void clear() {
        this.processApplication.clear();
    }
}

