/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.application.impl.event;

import java.util.concurrent.Callable;
import org.eximeebpms.bpm.application.InvocationContext;
import org.eximeebpms.bpm.application.ProcessApplicationInterface;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.application.ProcessApplicationUnavailableException;
import org.eximeebpms.bpm.application.impl.ProcessApplicationLogger;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.DelegateTask;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.delegate.TaskListener;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class ProcessApplicationEventListenerDelegate
implements ExecutionListener,
TaskListener {
    private static ProcessApplicationLogger LOG = ProcessApplicationLogger.PROCESS_APPLICATION_LOGGER;

    @Override
    public void notify(final DelegateExecution execution) throws Exception {
        Callable<Void> notification = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ProcessApplicationEventListenerDelegate.this.notifyExecutionListener(execution);
                return null;
            }
        };
        this.performNotification(execution, notification);
    }

    @Override
    public void notify(final DelegateTask delegateTask) {
        if (delegateTask.getExecution() == null) {
            LOG.taskNotRelatedToExecution(delegateTask);
        } else {
            DelegateExecution execution = delegateTask.getExecution();
            Callable<Void> notification = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProcessApplicationEventListenerDelegate.this.notifyTaskListener(delegateTask);
                    return null;
                }
            };
            try {
                this.performNotification(execution, notification);
            }
            catch (Exception e) {
                throw LOG.exceptionWhileNotifyingPaTaskListener(e);
            }
        }
    }

    protected void performNotification(DelegateExecution execution, Callable<Void> notification) throws Exception {
        ProcessApplicationReference processApp = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (processApp == null) {
            LOG.noTargetProcessApplicationForExecution(execution);
        } else if (ProcessApplicationContextUtil.requiresContextSwitch(processApp)) {
            Context.executeWithinProcessApplication(notification, processApp, new InvocationContext(execution));
        } else {
            notification.call();
        }
    }

    protected void notifyExecutionListener(DelegateExecution execution) throws Exception {
        ProcessApplicationReference processApp = Context.getCurrentProcessApplication();
        try {
            ProcessApplicationInterface processApplication = processApp.getProcessApplication();
            ExecutionListener executionListener = processApplication.getExecutionListener();
            if (executionListener != null) {
                executionListener.notify(execution);
            } else {
                LOG.paDoesNotProvideExecutionListener(processApp.getName());
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            LOG.cannotInvokeListenerPaUnavailable(processApp.getName(), e);
        }
    }

    protected void notifyTaskListener(DelegateTask task) throws Exception {
        ProcessApplicationReference processApp = Context.getCurrentProcessApplication();
        try {
            ProcessApplicationInterface processApplication = processApp.getProcessApplication();
            TaskListener taskListener = processApplication.getTaskListener();
            if (taskListener != null) {
                taskListener.notify(task);
            } else {
                LOG.paDoesNotProvideTaskListener(processApp.getName());
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            LOG.cannotInvokeListenerPaUnavailable(processApp.getName(), e);
        }
    }
}

