/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eximeebpms.bpm.container.impl.ContainerIntegrationLogger;
import org.eximeebpms.bpm.container.impl.metadata.BpmPlatformXmlParser;
import org.eximeebpms.bpm.container.impl.metadata.spi.BpmPlatformXml;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperation;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperationStep;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.util.ClassLoaderUtil;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractParseBpmPlatformXmlStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    public static final String BPM_PLATFORM_XML_FILE = "bpm-platform.xml";
    public static final String BPM_PLATFORM_XML_LOCATION = "bpm-platform-xml";
    public static final String BPM_PLATFORM_XML_ENVIRONMENT_VARIABLE = "BPM_PLATFORM_XML";
    public static final String BPM_PLATFORM_XML_SYSTEM_PROPERTY = "bpm.platform.xml";
    public static final String BPM_PLATFORM_XML_RESOURCE_LOCATION = "META-INF/bpm-platform.xml";

    @Override
    public String getName() {
        return "Parsing bpm-platform.xml file";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        URL bpmPlatformXmlSource = this.getBpmPlatformXmlStream(operationContext);
        EnsureUtil.ensureNotNull("Unable to find bpm-platform.xml. This file is necessary for deploying the Camunda Platform", "bpmPlatformXmlSource", (Object)bpmPlatformXmlSource);
        BpmPlatformXml bpmPlatformXml = new BpmPlatformXmlParser().createParse().sourceUrl(bpmPlatformXmlSource).execute().getBpmPlatformXml();
        operationContext.addAttachment("bpmPlatformXml", bpmPlatformXml);
    }

    public URL checkValidBpmPlatformXmlResourceLocation(String url) {
        url = this.autoCompleteUrl(url);
        URL fileLocation = null;
        try {
            fileLocation = this.checkValidUrlLocation(url);
            if (fileLocation == null) {
                fileLocation = this.checkValidFileLocation(url);
            }
        }
        catch (MalformedURLException e) {
            throw new ProcessEngineException("'" + url + "' is not a valid Camunda Platform configuration resource location.", e);
        }
        return fileLocation;
    }

    public String autoCompleteUrl(String url) {
        if (url != null) {
            LOG.debugAutoCompleteUrl((String)url);
            if (!((String)url).endsWith(BPM_PLATFORM_XML_FILE)) {
                String appender = ((String)url).contains("/") ? "/" : "\\";
                if (!((String)url).endsWith("/") && !((String)url).endsWith("\\\\")) {
                    url = (String)url + appender;
                }
                url = (String)url + BPM_PLATFORM_XML_FILE;
            }
            LOG.debugAutoCompletedUrl((String)url);
        }
        return url;
    }

    public URL checkValidUrlLocation(String url) throws MalformedURLException {
        if (url == null || url.isEmpty()) {
            return null;
        }
        Pattern urlPattern = Pattern.compile("^(https?://).*/bpm-platform\\.xml$", 66);
        Matcher urlMatcher = urlPattern.matcher(url);
        if (urlMatcher.matches()) {
            return new URL(url);
        }
        return null;
    }

    public URL checkValidFileLocation(String url) throws MalformedURLException {
        File configurationLocation;
        if (url == null || url.isEmpty()) {
            return null;
        }
        Pattern filePattern = Pattern.compile("^(/|[A-z]://?|[A-z]:\\\\).*[/|\\\\]bpm-platform\\.xml$", 66);
        Matcher fileMatcher = filePattern.matcher(url);
        if (fileMatcher.matches() && (configurationLocation = new File(url)).isAbsolute() && configurationLocation.exists()) {
            return configurationLocation.toURI().toURL();
        }
        return null;
    }

    public URL lookupBpmPlatformXmlLocationFromJndi() {
        String jndi = "java:comp/env/bpm-platform-xml";
        try {
            String bpmPlatformXmlLocation = (String)InitialContext.doLookup(jndi);
            URL fileLocation = this.checkValidBpmPlatformXmlResourceLocation(bpmPlatformXmlLocation);
            if (fileLocation != null) {
                LOG.foundConfigJndi(jndi, fileLocation.toString());
            }
            return fileLocation;
        }
        catch (NamingException e) {
            LOG.debugExceptionWhileGettingConfigFromJndi(jndi, e);
            return null;
        }
    }

    public URL lookupBpmPlatformXmlLocationFromEnvironmentVariable() {
        URL fileLocation;
        String bpmPlatformXmlLocation = System.getenv(BPM_PLATFORM_XML_ENVIRONMENT_VARIABLE);
        String logStatement = "environment variable [BPM_PLATFORM_XML]";
        if (bpmPlatformXmlLocation == null) {
            bpmPlatformXmlLocation = System.getProperty(BPM_PLATFORM_XML_SYSTEM_PROPERTY);
            logStatement = "system property [bpm.platform.xml]";
        }
        if ((fileLocation = this.checkValidBpmPlatformXmlResourceLocation(bpmPlatformXmlLocation)) != null) {
            LOG.foundConfigAtLocation(logStatement, fileLocation.toString());
        }
        return fileLocation;
    }

    public URL lookupBpmPlatformXmlFromClassPath(String resourceLocation) {
        URL fileLocation = ClassLoaderUtil.getClassloader(this.getClass()).getResource(resourceLocation);
        if (fileLocation != null) {
            LOG.foundConfigAtLocation(resourceLocation, fileLocation.toString());
        }
        return fileLocation;
    }

    public URL lookupBpmPlatformXmlFromClassPath() {
        return this.lookupBpmPlatformXmlFromClassPath(BPM_PLATFORM_XML_RESOURCE_LOCATION);
    }

    public URL lookupBpmPlatformXml() {
        URL fileLocation = this.lookupBpmPlatformXmlLocationFromJndi();
        if (fileLocation == null) {
            fileLocation = this.lookupBpmPlatformXmlLocationFromEnvironmentVariable();
        }
        if (fileLocation == null) {
            fileLocation = this.lookupBpmPlatformXmlFromClassPath();
        }
        return fileLocation;
    }

    public abstract URL getBpmPlatformXmlStream(DeploymentOperation var1);
}

