/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.deployment;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eximeebpms.bpm.application.AbstractProcessApplication;
import org.eximeebpms.bpm.application.PostDeploy;
import org.eximeebpms.bpm.container.impl.ContainerIntegrationLogger;
import org.eximeebpms.bpm.container.impl.deployment.util.InjectionUtil;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperation;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperationStep;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;

public class PostDeployInvocationStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    private static final String CALLBACK_NAME = "@PostDeploy";

    @Override
    public String getName() {
        return "Invoking @PostDeploy";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        String paName = processApplication.getName();
        Class<?> paClass = processApplication.getClass();
        Method postDeployMethod = InjectionUtil.detectAnnotatedMethod(paClass, PostDeploy.class);
        if (postDeployMethod == null) {
            LOG.debugPaLifecycleMethodNotFound(CALLBACK_NAME, paName);
            return;
        }
        LOG.debugFoundPaLifecycleCallbackMethod(CALLBACK_NAME, paName);
        Object[] injections = InjectionUtil.resolveInjections(operationContext, postDeployMethod);
        try {
            postDeployMethod.invoke((Object)processApplication, injections);
        }
        catch (IllegalArgumentException e) {
            throw LOG.exceptionWhileInvokingPaLifecycleCallback(CALLBACK_NAME, paName, e);
        }
        catch (IllegalAccessException e) {
            throw LOG.exceptionWhileInvokingPaLifecycleCallback(CALLBACK_NAME, paName, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw LOG.exceptionWhileInvokingPaLifecycleCallback(CALLBACK_NAME, paName, e);
        }
    }
}

