/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.deployment;

import java.util.ArrayList;
import java.util.Map;
import org.eximeebpms.bpm.application.AbstractProcessApplication;
import org.eximeebpms.bpm.application.ProcessApplicationDeploymentInfo;
import org.eximeebpms.bpm.application.impl.ProcessApplicationDeploymentInfoImpl;
import org.eximeebpms.bpm.application.impl.ProcessApplicationInfoImpl;
import org.eximeebpms.bpm.application.impl.metadata.spi.ProcessesXml;
import org.eximeebpms.bpm.container.impl.deployment.util.DeployedProcessArchive;
import org.eximeebpms.bpm.container.impl.jmx.services.JmxManagedBpmPlatformPlugins;
import org.eximeebpms.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.eximeebpms.bpm.container.impl.plugin.BpmPlatformPlugin;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperation;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperationStep;
import org.eximeebpms.bpm.container.impl.spi.PlatformServiceContainer;
import org.eximeebpms.bpm.container.impl.spi.ServiceTypes;

public class StartProcessApplicationServiceStep
extends DeploymentOperationStep {
    @Override
    public String getName() {
        return "Start Process Application Service";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        Map processesXmls = (Map)operationContext.getAttachment("processesXmlList");
        Map processArchiveDeploymentMap = (Map)operationContext.getAttachment("processArchiveDeploymentMap");
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        ProcessApplicationInfoImpl processApplicationInfo = this.createProcessApplicationInfo(processApplication, processArchiveDeploymentMap);
        JmxManagedProcessApplication mbean = new JmxManagedProcessApplication(processApplicationInfo, processApplication.getReference());
        mbean.setProcessesXmls(new ArrayList<ProcessesXml>(processesXmls.values()));
        mbean.setDeploymentMap(processArchiveDeploymentMap);
        serviceContainer.startService(ServiceTypes.PROCESS_APPLICATION, processApplication.getName(), mbean);
        this.notifyBpmPlatformPlugins(serviceContainer, processApplication);
    }

    protected ProcessApplicationInfoImpl createProcessApplicationInfo(AbstractProcessApplication processApplication, Map<String, DeployedProcessArchive> processArchiveDeploymentMap) {
        ProcessApplicationInfoImpl processApplicationInfo = new ProcessApplicationInfoImpl();
        processApplicationInfo.setName(processApplication.getName());
        processApplicationInfo.setProperties(processApplication.getProperties());
        ArrayList<ProcessApplicationDeploymentInfo> deploymentInfoList = new ArrayList<ProcessApplicationDeploymentInfo>();
        if (processArchiveDeploymentMap != null) {
            for (Map.Entry<String, DeployedProcessArchive> deployment : processArchiveDeploymentMap.entrySet()) {
                DeployedProcessArchive deployedProcessArchive = deployment.getValue();
                for (String deploymentId : deployedProcessArchive.getAllDeploymentIds()) {
                    ProcessApplicationDeploymentInfoImpl deploymentInfo = new ProcessApplicationDeploymentInfoImpl();
                    deploymentInfo.setDeploymentId(deploymentId);
                    deploymentInfo.setProcessEngineName(deployedProcessArchive.getProcessEngineName());
                    deploymentInfoList.add(deploymentInfo);
                }
            }
        }
        processApplicationInfo.setDeploymentInfo(deploymentInfoList);
        return processApplicationInfo;
    }

    protected void notifyBpmPlatformPlugins(PlatformServiceContainer serviceContainer, AbstractProcessApplication processApplication) {
        JmxManagedBpmPlatformPlugins plugins = (JmxManagedBpmPlatformPlugins)serviceContainer.getService(ServiceTypes.BPM_PLATFORM, "bpm-platform-plugins");
        if (plugins != null) {
            for (BpmPlatformPlugin plugin : plugins.getValue().getPlugins()) {
                plugin.postProcessApplicationDeploy(processApplication);
            }
        }
    }
}

