/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.deployment;

import java.util.List;
import org.eximeebpms.bpm.application.ProcessApplicationInterface;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.container.impl.ContainerIntegrationLogger;
import org.eximeebpms.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperation;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperationStep;
import org.eximeebpms.bpm.container.impl.spi.PlatformServiceContainer;
import org.eximeebpms.bpm.container.impl.spi.ServiceTypes;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;

public class StopProcessApplicationsStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public String getName() {
        return "Stopping process applications";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        List processApplicationsReferences = serviceContainer.getServiceValuesByType(ServiceTypes.PROCESS_APPLICATION);
        for (JmxManagedProcessApplication processApplication : processApplicationsReferences) {
            this.stopProcessApplication(processApplication.getProcessApplicationReference());
        }
    }

    protected void stopProcessApplication(ProcessApplicationReference processApplicationReference) {
        try {
            ProcessApplicationInterface processApplication = processApplicationReference.getProcessApplication();
            processApplication.undeploy();
        }
        catch (Throwable t) {
            LOG.exceptionWhileStopping("Process Application", processApplicationReference.getName(), t);
        }
    }
}

