/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.deployment;

import java.util.Set;
import org.eximeebpms.bpm.container.impl.ContainerIntegrationLogger;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperation;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperationStep;
import org.eximeebpms.bpm.container.impl.spi.PlatformServiceContainer;
import org.eximeebpms.bpm.container.impl.spi.ServiceTypes;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;

public class StopProcessEnginesStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        Set<String> serviceNames = serviceContainer.getServiceNames(ServiceTypes.PROCESS_ENGINE);
        for (String serviceName : serviceNames) {
            this.stopProcessEngine(serviceName, serviceContainer);
        }
    }

    private void stopProcessEngine(String serviceName, PlatformServiceContainer serviceContainer) {
        try {
            serviceContainer.stopService(serviceName);
        }
        catch (Exception e) {
            LOG.exceptionWhileStopping("Process Engine", serviceName, e);
        }
    }
}

