/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.deployment;

import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.application.AbstractProcessApplication;
import org.eximeebpms.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.eximeebpms.bpm.application.impl.metadata.spi.ProcessesXml;
import org.eximeebpms.bpm.container.impl.deployment.UndeployProcessArchiveStep;
import org.eximeebpms.bpm.container.impl.deployment.util.DeployedProcessArchive;
import org.eximeebpms.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperation;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperationStep;
import org.eximeebpms.bpm.container.impl.spi.PlatformServiceContainer;
import org.eximeebpms.bpm.container.impl.spi.ServiceTypes;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class UndeployProcessArchivesStep
extends DeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        JmxManagedProcessApplication deployedProcessApplication = (JmxManagedProcessApplication)serviceContainer.getService(ServiceTypes.PROCESS_APPLICATION, processApplication.getName());
        EnsureUtil.ensureNotNull("Cannot find process application with name " + processApplication.getName(), "deployedProcessApplication", (Object)deployedProcessApplication);
        Map<String, DeployedProcessArchive> deploymentMap = deployedProcessApplication.getProcessArchiveDeploymentMap();
        if (deploymentMap != null) {
            List<ProcessesXml> processesXmls = deployedProcessApplication.getProcessesXmls();
            for (ProcessesXml processesXml : processesXmls) {
                for (ProcessArchiveXml parsedProcessArchive : processesXml.getProcessArchives()) {
                    DeployedProcessArchive deployedProcessArchive = deploymentMap.get(parsedProcessArchive.getName());
                    if (deployedProcessArchive == null) continue;
                    operationContext.addStep(new UndeployProcessArchiveStep(deployedProcessApplication, parsedProcessArchive, deployedProcessArchive.getProcessEngineName()));
                }
            }
        }
    }
}

