/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.deployment.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.application.AbstractProcessApplication;
import org.eximeebpms.bpm.application.ProcessApplicationDeploymentInfo;
import org.eximeebpms.bpm.application.ProcessApplicationInfo;
import org.eximeebpms.bpm.container.impl.ContainerIntegrationLogger;
import org.eximeebpms.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperation;
import org.eximeebpms.bpm.container.impl.spi.PlatformServiceContainer;
import org.eximeebpms.bpm.container.impl.spi.ServiceTypes;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;

public class InjectionUtil {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    public static Method detectAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotationType) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            for (Annotation annotaiton : method.getAnnotations()) {
                if (!annotationType.equals(annotaiton.annotationType())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object[] resolveInjections(DeploymentOperation operationContext, Method lifecycleMethod) {
        Type[] parameterTypes = lifecycleMethod.getGenericParameterTypes();
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Type parameterType : parameterTypes) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            boolean injectionResolved = false;
            if (parameterType instanceof Class) {
                Class parameterClass = (Class)parameterType;
                if (ProcessEngine.class.isAssignableFrom(parameterClass)) {
                    parameters.add(InjectionUtil.getDefaultProcessEngine(operationContext));
                    injectionResolved = true;
                } else if (ProcessApplicationInfo.class.isAssignableFrom(parameterClass)) {
                    parameters.add(InjectionUtil.getProcessApplicationInfo(operationContext));
                    injectionResolved = true;
                }
            } else if (parameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)parameterType).getActualTypeArguments()).length == 1 && ProcessEngine.class.isAssignableFrom((Class)actualTypeArguments[0])) {
                parameters.add(InjectionUtil.getProcessEngines(operationContext));
                injectionResolved = true;
            }
            if (injectionResolved) continue;
            throw LOG.unsuppoertedParameterType(parameterType);
        }
        return parameters.toArray();
    }

    public static ProcessApplicationInfo getProcessApplicationInfo(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        JmxManagedProcessApplication managedPa = (JmxManagedProcessApplication)serviceContainer.getServiceValue(ServiceTypes.PROCESS_APPLICATION, processApplication.getName());
        return managedPa.getProcessApplicationInfo();
    }

    public static List<ProcessEngine> getProcessEngines(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        ProcessApplicationInfo processApplicationInfo = InjectionUtil.getProcessApplicationInfo(operationContext);
        ArrayList<ProcessEngine> processEngines = new ArrayList<ProcessEngine>();
        for (ProcessApplicationDeploymentInfo deploymentInfo : processApplicationInfo.getDeploymentInfo()) {
            String processEngineName = deploymentInfo.getProcessEngineName();
            processEngines.add((ProcessEngine)serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, processEngineName));
        }
        return processEngines;
    }

    public static ProcessEngine getDefaultProcessEngine(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        return (ProcessEngine)serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, "default");
    }
}

