/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.jmx.services;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eximeebpms.bpm.container.impl.ContainerIntegrationLogger;
import org.eximeebpms.bpm.container.impl.jmx.services.JmxManagedThreadPoolMBean;
import org.eximeebpms.bpm.container.impl.spi.PlatformService;
import org.eximeebpms.bpm.container.impl.spi.PlatformServiceContainer;
import org.eximeebpms.bpm.container.impl.threading.se.SeExecutorService;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;

public class JmxManagedThreadPool
extends SeExecutorService
implements JmxManagedThreadPoolMBean,
PlatformService<JmxManagedThreadPool> {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected final BlockingQueue<Runnable> threadPoolQueue;

    public JmxManagedThreadPool(BlockingQueue<Runnable> queue, ThreadPoolExecutor executor) {
        super(executor);
        this.threadPoolQueue = queue;
    }

    @Override
    public void start(PlatformServiceContainer mBeanServiceContainer) {
    }

    @Override
    public void stop(PlatformServiceContainer mBeanServiceContainer) {
        this.threadPoolQueue.clear();
        this.threadPoolExecutor.shutdown();
        try {
            if (!this.threadPoolExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOG.timeoutDuringShutdownOfThreadPool(60, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            LOG.interruptedWhileShuttingDownThreadPool(e);
        }
    }

    @Override
    public JmxManagedThreadPool getValue() {
        return this;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        this.threadPoolExecutor.setCorePoolSize(corePoolSize);
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.threadPoolExecutor.setMaximumPoolSize(maximumPoolSize);
    }

    @Override
    public int getMaximumPoolSize() {
        return this.threadPoolExecutor.getMaximumPoolSize();
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        this.threadPoolExecutor.setKeepAliveTime(time, unit);
    }

    @Override
    public void purgeThreadPool() {
        this.threadPoolExecutor.purge();
    }

    @Override
    public int getPoolSize() {
        return this.threadPoolExecutor.getPoolSize();
    }

    @Override
    public int getActiveCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    @Override
    public int getLargestPoolSize() {
        return this.threadPoolExecutor.getLargestPoolSize();
    }

    @Override
    public long getTaskCount() {
        return this.threadPoolExecutor.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.threadPoolExecutor.getCompletedTaskCount();
    }

    @Override
    public int getQueueCount() {
        return this.threadPoolQueue.size();
    }

    public int getQueueAddlCapacity() {
        return this.threadPoolQueue.remainingCapacity();
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }
}

