/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.util.List;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.AuthorizationQuery;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.impl.AuthorizationQueryImpl;
import org.eximeebpms.bpm.engine.impl.ServiceImpl;
import org.eximeebpms.bpm.engine.impl.cmd.AuthorizationCheckCmd;
import org.eximeebpms.bpm.engine.impl.cmd.CreateAuthorizationCommand;
import org.eximeebpms.bpm.engine.impl.cmd.DeleteAuthorizationCmd;
import org.eximeebpms.bpm.engine.impl.cmd.SaveAuthorizationCmd;

public class AuthorizationServiceImpl
extends ServiceImpl
implements AuthorizationService {
    @Override
    public AuthorizationQuery createAuthorizationQuery() {
        return new AuthorizationQueryImpl(this.commandExecutor);
    }

    @Override
    public Authorization createNewAuthorization(int type) {
        return this.commandExecutor.execute(new CreateAuthorizationCommand(type));
    }

    @Override
    public Authorization saveAuthorization(Authorization authorization) {
        return this.commandExecutor.execute(new SaveAuthorizationCmd(authorization));
    }

    @Override
    public void deleteAuthorization(String authorizationId) {
        this.commandExecutor.execute(new DeleteAuthorizationCmd(authorizationId));
    }

    @Override
    public boolean isUserAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource) {
        return this.commandExecutor.execute(new AuthorizationCheckCmd(userId, groupIds, permission, resource, null));
    }

    @Override
    public boolean isUserAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource, String resourceId) {
        return this.commandExecutor.execute(new AuthorizationCheckCmd(userId, groupIds, permission, resource, resourceId));
    }
}

