/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricActivityStatistics;
import org.eximeebpms.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.eximeebpms.bpm.engine.impl.AbstractQuery;
import org.eximeebpms.bpm.engine.impl.HistoricActivityStatisticsQueryProperty;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class HistoricActivityStatisticsQueryImpl
extends AbstractQuery<HistoricActivityStatisticsQuery, HistoricActivityStatistics>
implements HistoricActivityStatisticsQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected boolean includeFinished;
    protected boolean includeCanceled;
    protected boolean includeCompleteScope;
    protected boolean includeIncidents;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected String[] processInstanceIds;

    public HistoricActivityStatisticsQueryImpl(String processDefinitionId, CommandExecutor commandExecutor) {
        super(commandExecutor);
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public HistoricActivityStatisticsQuery includeFinished() {
        this.includeFinished = true;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery includeCanceled() {
        this.includeCanceled = true;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery includeCompleteScope() {
        this.includeCompleteScope = true;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery includeIncidents() {
        this.includeIncidents = true;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery startedAfter(Date date) {
        this.startedAfter = date;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery startedBefore(Date date) {
        this.startedBefore = date;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery finishedAfter(Date date) {
        this.finishedAfter = date;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery finishedBefore(Date date) {
        this.finishedBefore = date;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery processInstanceIdIn(String ... processInstanceIds) {
        EnsureUtil.ensureNotNull("processInstanceIds", processInstanceIds);
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public HistoricActivityStatisticsQuery orderByActivityId() {
        return (HistoricActivityStatisticsQuery)this.orderBy(HistoricActivityStatisticsQueryProperty.ACTIVITY_ID_);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricStatisticsManager().getHistoricStatisticsCountGroupedByActivity(this);
    }

    @Override
    public List<HistoricActivityStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricStatisticsManager().getHistoricStatisticsGroupedByActivity(this, page);
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        EnsureUtil.ensureNotNull("No valid process definition id supplied", "processDefinitionId", (Object)this.processDefinitionId);
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public boolean isIncludeFinished() {
        return this.includeFinished;
    }

    public boolean isIncludeCanceled() {
        return this.includeCanceled;
    }

    public boolean isIncludeCompleteScope() {
        return this.includeCompleteScope;
    }

    public String[] getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public boolean isIncludeIncidents() {
        return this.includeIncidents;
    }
}

