/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstanceStatistics;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstanceStatisticsQuery;
import org.eximeebpms.bpm.engine.impl.AbstractQuery;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class HistoricDecisionInstanceStatisticsQueryImpl
extends AbstractQuery<HistoricDecisionInstanceStatisticsQuery, HistoricDecisionInstanceStatistics>
implements HistoricDecisionInstanceStatisticsQuery {
    protected final String decisionRequirementsDefinitionId;
    protected String decisionInstanceId;

    public HistoricDecisionInstanceStatisticsQueryImpl(String decisionRequirementsDefinitionId, CommandExecutor commandExecutor) {
        super(commandExecutor);
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        long count = commandContext.getStatisticsManager().getStatisticsCountGroupedByDecisionRequirementsDefinition(this);
        return count;
    }

    @Override
    public List<HistoricDecisionInstanceStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        List<HistoricDecisionInstanceStatistics> statisticsList = commandContext.getStatisticsManager().getStatisticsGroupedByDecisionRequirementsDefinition(this, page);
        return statisticsList;
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        EnsureUtil.ensureNotNull("decisionRequirementsDefinitionId", (Object)this.decisionRequirementsDefinitionId);
    }

    public String getDecisionRequirementsDefinitionId() {
        return this.decisionRequirementsDefinitionId;
    }

    @Override
    public HistoricDecisionInstanceStatisticsQuery decisionInstanceId(String decisionInstanceId) {
        this.decisionInstanceId = decisionInstanceId;
        return this;
    }

    public String getDecisionInstanceId() {
        return this.decisionInstanceId;
    }

    public void setDecisionInstanceId(String decisionInstanceId) {
        this.decisionInstanceId = decisionInstanceId;
    }
}

