/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.AbstractQuery;
import org.eximeebpms.bpm.engine.impl.JobDefinitionQueryProperty;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.SuspensionState;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.management.JobDefinitionQuery;

public class JobDefinitionQueryImpl
extends AbstractQuery<JobDefinitionQuery, JobDefinition>
implements JobDefinitionQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] activityIds;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String jobType;
    protected String jobConfiguration;
    protected SuspensionState suspensionState;
    protected Boolean withOverridingJobPriority;
    protected boolean isTenantIdSet = false;
    protected String[] tenantIds;
    protected boolean includeJobDefinitionsWithoutTenantId = false;

    public JobDefinitionQueryImpl() {
    }

    public JobDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public JobDefinitionQuery jobDefinitionId(String jobDefinitionId) {
        EnsureUtil.ensureNotNull("Job definition id", (Object)jobDefinitionId);
        this.id = jobDefinitionId;
        return this;
    }

    @Override
    public JobDefinitionQuery activityIdIn(String ... activityIds) {
        EnsureUtil.ensureNotNull("Activity ids", activityIds);
        this.activityIds = activityIds;
        return this;
    }

    @Override
    public JobDefinitionQuery processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("Process definition id", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public JobDefinitionQuery processDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("Process definition key", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public JobDefinitionQuery jobType(String jobType) {
        EnsureUtil.ensureNotNull("Job type", (Object)jobType);
        this.jobType = jobType;
        return this;
    }

    @Override
    public JobDefinitionQuery jobConfiguration(String jobConfiguration) {
        EnsureUtil.ensureNotNull("Job configuration", (Object)jobConfiguration);
        this.jobConfiguration = jobConfiguration;
        return this;
    }

    @Override
    public JobDefinitionQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public JobDefinitionQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public JobDefinitionQuery withOverridingJobPriority() {
        this.withOverridingJobPriority = true;
        return this;
    }

    @Override
    public JobDefinitionQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public JobDefinitionQuery withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantIds = null;
        return this;
    }

    @Override
    public JobDefinitionQuery includeJobDefinitionsWithoutTenantId() {
        this.includeJobDefinitionsWithoutTenantId = true;
        return this;
    }

    @Override
    public JobDefinitionQuery orderByJobDefinitionId() {
        return (JobDefinitionQuery)this.orderBy(JobDefinitionQueryProperty.JOB_DEFINITION_ID);
    }

    @Override
    public JobDefinitionQuery orderByActivityId() {
        return (JobDefinitionQuery)this.orderBy(JobDefinitionQueryProperty.ACTIVITY_ID);
    }

    @Override
    public JobDefinitionQuery orderByProcessDefinitionId() {
        return (JobDefinitionQuery)this.orderBy(JobDefinitionQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public JobDefinitionQuery orderByProcessDefinitionKey() {
        return (JobDefinitionQuery)this.orderBy(JobDefinitionQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public JobDefinitionQuery orderByJobType() {
        return (JobDefinitionQuery)this.orderBy(JobDefinitionQueryProperty.JOB_TYPE);
    }

    @Override
    public JobDefinitionQuery orderByJobConfiguration() {
        return (JobDefinitionQuery)this.orderBy(JobDefinitionQueryProperty.JOB_CONFIGURATION);
    }

    @Override
    public JobDefinitionQuery orderByTenantId() {
        return (JobDefinitionQuery)this.orderBy(JobDefinitionQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getJobDefinitionManager().findJobDefinitionCountByQueryCriteria(this);
    }

    @Override
    public List<JobDefinition> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getJobDefinitionManager().findJobDefnitionByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public String[] getActivityIds() {
        return this.activityIds;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getJobConfiguration() {
        return this.jobConfiguration;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public Boolean getWithOverridingJobPriority() {
        return this.withOverridingJobPriority;
    }
}

