/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.ModificationBatchConfiguration;
import org.eximeebpms.bpm.engine.impl.ModificationBuilderImpl;
import org.eximeebpms.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobContext;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobDeclaration;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.eximeebpms.bpm.engine.impl.json.ModificationBatchConfigurationJsonConverter;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class ModificationBatchJobHandler
extends AbstractBatchJobHandler<ModificationBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("instance-modification");

    @Override
    public String getType() {
        return "instance-modification";
    }

    @Override
    protected void postProcessJob(ModificationBatchConfiguration configuration, JobEntity job, ModificationBatchConfiguration jobConfiguration) {
        if (job.getDeploymentId() == null) {
            CommandContext commandContext = Context.getCommandContext();
            ProcessDefinitionEntity processDefinitionEntity = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(configuration.getProcessDefinitionId());
            job.setDeploymentId(processDefinitionEntity.getDeploymentId());
        }
    }

    @Override
    public void executeHandler(ModificationBatchConfiguration batchConfiguration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ModificationBuilderImpl executionBuilder = (ModificationBuilderImpl)commandContext.getProcessEngineConfiguration().getRuntimeService().createModification(batchConfiguration.getProcessDefinitionId()).processInstanceIds(batchConfiguration.getIds());
        executionBuilder.setInstructions(batchConfiguration.getInstructions());
        if (batchConfiguration.isSkipCustomListeners()) {
            executionBuilder.skipCustomListeners();
        }
        if (batchConfiguration.isSkipIoMappings()) {
            executionBuilder.skipIoMappings();
        }
        executionBuilder.execute(false);
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected ModificationBatchConfiguration createJobConfiguration(ModificationBatchConfiguration configuration, List<String> processIdsForJob) {
        return new ModificationBatchConfiguration(processIdsForJob, configuration.getProcessDefinitionId(), configuration.getInstructions(), configuration.isSkipCustomListeners(), configuration.isSkipIoMappings());
    }

    protected ModificationBatchConfigurationJsonConverter getJsonConverterInstance() {
        return ModificationBatchConfigurationJsonConverter.INSTANCE;
    }

    protected ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }
}

