/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.AbstractQuery;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.management.ProcessDefinitionStatistics;
import org.eximeebpms.bpm.engine.management.ProcessDefinitionStatisticsQuery;

public class ProcessDefinitionStatisticsQueryImpl
extends AbstractQuery<ProcessDefinitionStatisticsQuery, ProcessDefinitionStatistics>
implements ProcessDefinitionStatisticsQuery {
    protected static final long serialVersionUID = 1L;
    protected boolean includeFailedJobs = false;
    protected boolean includeIncidents = false;
    protected boolean includeRootIncidents = false;
    protected String includeIncidentsForType;

    public ProcessDefinitionStatisticsQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsCountGroupedByProcessDefinitionVersion(this);
    }

    @Override
    public List<ProcessDefinitionStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsGroupedByProcessDefinitionVersion(this, page);
    }

    @Override
    public ProcessDefinitionStatisticsQuery includeFailedJobs() {
        this.includeFailedJobs = true;
        return this;
    }

    @Override
    public ProcessDefinitionStatisticsQuery includeIncidents() {
        this.includeIncidents = true;
        return this;
    }

    @Override
    public ProcessDefinitionStatisticsQuery includeIncidentsForType(String incidentType) {
        this.includeIncidentsForType = incidentType;
        return this;
    }

    public boolean isFailedJobsToInclude() {
        return this.includeFailedJobs;
    }

    public boolean isIncidentsToInclude() {
        return this.includeIncidents || this.includeRootIncidents || this.includeIncidentsForType != null;
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        if (this.includeIncidents && this.includeIncidentsForType != null) {
            throw new ProcessEngineException("Invalid query: It is not possible to use includeIncident() and includeIncidentForType() to execute one query.");
        }
        if (this.includeRootIncidents && this.includeIncidentsForType != null) {
            throw new ProcessEngineException("Invalid query: It is not possible to use includeRootIncident() and includeIncidentForType() to execute one query.");
        }
        if (this.includeIncidents && this.includeRootIncidents) {
            throw new ProcessEngineException("Invalid query: It is not possible to use includeIncident() and includeRootIncidents() to execute one query.");
        }
    }

    @Override
    public ProcessDefinitionStatisticsQuery includeRootIncidents() {
        this.includeRootIncidents = true;
        return this;
    }
}

