/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.eximeebpms.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.eximeebpms.bpm.engine.impl.cmd.ActivityAfterInstantiationCmd;
import org.eximeebpms.bpm.engine.impl.cmd.ActivityBeforeInstantiationCmd;
import org.eximeebpms.bpm.engine.impl.cmd.ActivityCancellationCmd;
import org.eximeebpms.bpm.engine.impl.cmd.ActivityInstanceCancellationCmd;
import org.eximeebpms.bpm.engine.impl.cmd.ModifyProcessInstanceAsyncCmd;
import org.eximeebpms.bpm.engine.impl.cmd.ModifyProcessInstanceCmd;
import org.eximeebpms.bpm.engine.impl.cmd.TransitionInstanceCancellationCmd;
import org.eximeebpms.bpm.engine.impl.cmd.TransitionInstantiationCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.impl.VariableMapImpl;

public class ProcessInstanceModificationBuilderImpl
implements ProcessInstanceModificationInstantiationBuilder {
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected String processInstanceId;
    protected String modificationReason;
    protected boolean skipCustomListeners = false;
    protected boolean skipIoMappings = false;
    protected boolean externallyTerminated = false;
    protected String annotation;
    protected List<AbstractProcessInstanceModificationCommand> operations = new ArrayList<AbstractProcessInstanceModificationCommand>();
    protected VariableMap processVariables = new VariableMapImpl();

    public ProcessInstanceModificationBuilderImpl(CommandExecutor commandExecutor, String processInstanceId) {
        this(processInstanceId);
        this.commandExecutor = commandExecutor;
    }

    public ProcessInstanceModificationBuilderImpl(CommandContext commandContext, String processInstanceId) {
        this(processInstanceId);
        this.commandContext = commandContext;
    }

    public ProcessInstanceModificationBuilderImpl(CommandContext commandContext, String processInstanceId, String modificationReason) {
        this(processInstanceId);
        this.commandContext = commandContext;
        this.modificationReason = modificationReason;
    }

    public ProcessInstanceModificationBuilderImpl(String processInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
    }

    public ProcessInstanceModificationBuilderImpl() {
    }

    @Override
    public ProcessInstanceModificationBuilder cancelActivityInstance(String activityInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityInstanceId", (Object)activityInstanceId);
        this.operations.add(new ActivityInstanceCancellationCmd(this.processInstanceId, activityInstanceId, this.modificationReason));
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder cancelTransitionInstance(String transitionInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "transitionInstanceId", (Object)transitionInstanceId);
        this.operations.add(new TransitionInstanceCancellationCmd(this.processInstanceId, transitionInstanceId));
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder cancelAllForActivity(String activityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        this.operations.add(new ActivityCancellationCmd(this.processInstanceId, activityId));
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder cancellationSourceExternal(boolean external) {
        this.externallyTerminated = external;
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder startBeforeActivity(String activityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        ActivityBeforeInstantiationCmd currentInstantiation = new ActivityBeforeInstantiationCmd(this.processInstanceId, activityId);
        this.operations.add(currentInstantiation);
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder startBeforeActivity(String activityId, String ancestorActivityInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        EnsureUtil.ensureNotNull(NotValidException.class, "ancestorActivityInstanceId", (Object)ancestorActivityInstanceId);
        ActivityBeforeInstantiationCmd currentInstantiation = new ActivityBeforeInstantiationCmd(this.processInstanceId, activityId, ancestorActivityInstanceId);
        this.operations.add(currentInstantiation);
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder startAfterActivity(String activityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        ActivityAfterInstantiationCmd currentInstantiation = new ActivityAfterInstantiationCmd(this.processInstanceId, activityId);
        this.operations.add(currentInstantiation);
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder startAfterActivity(String activityId, String ancestorActivityInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        EnsureUtil.ensureNotNull(NotValidException.class, "ancestorActivityInstanceId", (Object)ancestorActivityInstanceId);
        ActivityAfterInstantiationCmd currentInstantiation = new ActivityAfterInstantiationCmd(this.processInstanceId, activityId, ancestorActivityInstanceId);
        this.operations.add(currentInstantiation);
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder startTransition(String transitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "transitionId", (Object)transitionId);
        TransitionInstantiationCmd currentInstantiation = new TransitionInstantiationCmd(this.processInstanceId, transitionId);
        this.operations.add(currentInstantiation);
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder startTransition(String transitionId, String ancestorActivityInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "transitionId", (Object)transitionId);
        EnsureUtil.ensureNotNull(NotValidException.class, "ancestorActivityInstanceId", (Object)ancestorActivityInstanceId);
        TransitionInstantiationCmd currentInstantiation = new TransitionInstantiationCmd(this.processInstanceId, transitionId, ancestorActivityInstanceId);
        this.operations.add(currentInstantiation);
        return this;
    }

    protected AbstractInstantiationCmd getCurrentInstantiation() {
        if (this.operations.isEmpty()) {
            return null;
        }
        AbstractProcessInstanceModificationCommand lastInstantiationCmd = this.operations.get(this.operations.size() - 1);
        if (!(lastInstantiationCmd instanceof AbstractInstantiationCmd)) {
            throw new ProcessEngineException("last instruction is not an instantiation");
        }
        return (AbstractInstantiationCmd)lastInstantiationCmd;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder setVariable(String name, Object value) {
        EnsureUtil.ensureNotNull(NotValidException.class, "Variable name must not be null", "name", (Object)name);
        AbstractInstantiationCmd currentInstantiation = this.getCurrentInstantiation();
        if (currentInstantiation != null) {
            currentInstantiation.addVariable(name, value);
        } else {
            this.processVariables.put((Object)name, value);
        }
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder setVariableLocal(String name, Object value) {
        EnsureUtil.ensureNotNull(NotValidException.class, "Variable name must not be null", "name", (Object)name);
        AbstractInstantiationCmd currentInstantiation = this.getCurrentInstantiation();
        if (currentInstantiation != null) {
            currentInstantiation.addVariableLocal(name, value);
        } else {
            this.processVariables.put((Object)name, value);
        }
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder setVariables(Map<String, Object> variables) {
        EnsureUtil.ensureNotNull(NotValidException.class, "Variable map must not be null", "variables", variables);
        AbstractInstantiationCmd currentInstantiation = this.getCurrentInstantiation();
        if (currentInstantiation != null) {
            currentInstantiation.addVariables(variables);
        } else {
            this.processVariables.putAll(variables);
        }
        return this;
    }

    @Override
    public ProcessInstanceModificationInstantiationBuilder setVariablesLocal(Map<String, Object> variables) {
        EnsureUtil.ensureNotNull(NotValidException.class, "Variable map must not be null", "variablesLocal", variables);
        AbstractInstantiationCmd currentInstantiation = this.getCurrentInstantiation();
        if (currentInstantiation != null) {
            currentInstantiation.addVariablesLocal(variables);
        } else {
            this.processVariables.putAll(variables);
        }
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder setAnnotation(String annotation) {
        EnsureUtil.ensureNotNull(NotValidException.class, "Annotation must not be null", "annotation", (Object)annotation);
        this.annotation = annotation;
        return this;
    }

    @Override
    public void execute() {
        this.execute(false, false);
    }

    @Override
    public void execute(boolean skipCustomListeners, boolean skipIoMappings) {
        this.execute(true, skipCustomListeners, skipIoMappings);
    }

    public void execute(boolean writeUserOperationLog, boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMappings = skipIoMappings;
        ModifyProcessInstanceCmd cmd = new ModifyProcessInstanceCmd(this, writeUserOperationLog);
        if (this.commandExecutor != null) {
            this.commandExecutor.execute(cmd);
        } else {
            cmd.execute(this.commandContext);
        }
    }

    @Override
    public Batch executeAsync() {
        return this.executeAsync(false, false);
    }

    @Override
    public Batch executeAsync(boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMappings = skipIoMappings;
        return this.commandExecutor.execute(new ModifyProcessInstanceAsyncCmd(this));
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public List<AbstractProcessInstanceModificationCommand> getModificationOperations() {
        return this.operations;
    }

    public void setModificationOperations(List<AbstractProcessInstanceModificationCommand> operations) {
        this.operations = operations;
    }

    public boolean isSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public boolean isSkipIoMappings() {
        return this.skipIoMappings;
    }

    public boolean isExternallyTerminated() {
        return this.externallyTerminated;
    }

    public void setSkipCustomListeners(boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }

    public void setSkipIoMappings(boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
    }

    public VariableMap getProcessVariables() {
        return this.processVariables;
    }

    public String getModificationReason() {
        return this.modificationReason;
    }

    public void setModificationReason(String modificationReason) {
        this.modificationReason = modificationReason;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotationInternal(String annotation) {
        this.annotation = annotation;
    }
}

