/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.impl.AbstractQuery;
import org.eximeebpms.bpm.engine.impl.Validator;
import org.eximeebpms.bpm.engine.impl.context.Context;

public class QueryValidators {

    public static class StoredQueryValidator<T extends AbstractQuery<?, ?>>
    implements Validator<T> {
        public static final StoredQueryValidator INSTANCE = new StoredQueryValidator();

        private StoredQueryValidator() {
        }

        @Override
        public void validate(T query) {
            if (!Context.getProcessEngineConfiguration().isEnableExpressionsInStoredQueries() && !((AbstractQuery)query).getExpressions().isEmpty()) {
                throw new BadUserRequestException("Expressions are forbidden in stored queries. This behavior can be toggled in the process engine configuration");
            }
        }

        public static <T extends AbstractQuery<?, ?>> StoredQueryValidator<T> get() {
            return INSTANCE;
        }
    }

    public static class AdhocQueryValidator<T extends AbstractQuery<?, ?>>
    implements Validator<T> {
        public static final AdhocQueryValidator INSTANCE = new AdhocQueryValidator();

        private AdhocQueryValidator() {
        }

        @Override
        public void validate(T query) {
            if (!Context.getProcessEngineConfiguration().isEnableExpressionsInAdhocQueries() && !((AbstractQuery)query).getExpressions().isEmpty()) {
                throw new BadUserRequestException("Expressions are forbidden in adhoc queries. This behavior can be toggled in the process engine configuration");
            }
        }

        public static <T extends AbstractQuery<?, ?>> AdhocQueryValidator<T> get() {
            return INSTANCE;
        }
    }
}

