/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.AbstractQueryVariableValueCondition;
import org.eximeebpms.bpm.engine.impl.QueryOperator;
import org.eximeebpms.bpm.engine.impl.QueryVariableValue;
import org.eximeebpms.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.eximeebpms.bpm.engine.impl.variable.serializer.ValueFields;
import org.eximeebpms.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.eximeebpms.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;

public class SingleQueryVariableValueCondition
extends AbstractQueryVariableValueCondition
implements ValueFields {
    protected String textValue;
    protected String textValue2;
    protected Long longValue;
    protected Double doubleValue;
    protected String type;
    protected boolean findNulledEmptyStrings;

    public SingleQueryVariableValueCondition(QueryVariableValue variableValue) {
        super(variableValue);
    }

    @Override
    public void initializeValue(VariableSerializers serializers, String dbType) {
        TypedValue typedValue = this.wrappedQueryValue.getTypedValue();
        this.initializeValue(serializers, typedValue, dbType);
    }

    public void initializeValue(VariableSerializers serializers, TypedValue typedValue, String dbType) {
        TypedValueSerializer serializer = this.determineSerializer(serializers, (TypedValue)typedValue);
        if (typedValue instanceof UntypedValueImpl) {
            typedValue = serializer.convertToTypedValue((UntypedValueImpl)typedValue);
        }
        serializer.writeValue(typedValue, this);
        this.type = serializer.getName();
        if (ValueType.STRING.getName().equals(this.type) && "oracle".equals(dbType) && "".equals(this.textValue) && Arrays.asList(QueryOperator.EQUALS, QueryOperator.NOT_EQUALS).contains((Object)this.wrappedQueryValue.getOperator())) {
            this.findNulledEmptyStrings = true;
        }
    }

    protected TypedValueSerializer determineSerializer(VariableSerializers serializers, TypedValue value) {
        TypedValueSerializer serializer = serializers.findSerializerForValue(value);
        if (serializer.getType() == ValueType.BYTES) {
            throw new ProcessEngineException("Variables of type ByteArray cannot be used to query");
        }
        if (serializer.getType() == ValueType.FILE) {
            throw new ProcessEngineException("Variables of type File cannot be used to query");
        }
        if (!serializer.getType().isPrimitiveValueType()) {
            throw new ProcessEngineException("Object values cannot be used to query");
        }
        return serializer;
    }

    @Override
    public List<SingleQueryVariableValueCondition> getDisjunctiveConditions() {
        return Collections.singletonList(this);
    }

    @Override
    public String getName() {
        return this.wrappedQueryValue.getName();
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public byte[] getByteArrayValue() {
        return null;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
    }

    public String getType() {
        return this.type;
    }

    public boolean getFindNulledEmptyStrings() {
        return this.findNulledEmptyStrings;
    }

    public void setFindNulledEmptyStrings(boolean findNulledEmptyStrings) {
        this.findNulledEmptyStrings = findNulledEmptyStrings;
    }
}

