/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import org.eximeebpms.bpm.engine.identity.Tenant;
import org.eximeebpms.bpm.engine.identity.TenantQuery;
import org.eximeebpms.bpm.engine.impl.AbstractQuery;
import org.eximeebpms.bpm.engine.impl.TenantQueryProperty;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public abstract class TenantQueryImpl
extends AbstractQuery<TenantQuery, Tenant>
implements TenantQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String name;
    protected String nameLike;
    protected String userId;
    protected String groupId;
    protected boolean includingGroups = false;

    public TenantQueryImpl() {
    }

    public TenantQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public TenantQuery tenantId(String id) {
        EnsureUtil.ensureNotNull("tenant ud", (Object)id);
        this.id = id;
        return this;
    }

    @Override
    public TenantQuery tenantIdIn(String ... ids) {
        EnsureUtil.ensureNotNull("tenant ids", ids);
        this.ids = ids;
        return this;
    }

    @Override
    public TenantQuery tenantName(String name) {
        EnsureUtil.ensureNotNull("tenant name", (Object)name);
        this.name = name;
        return this;
    }

    @Override
    public TenantQuery tenantNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("tenant name like", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public TenantQuery userMember(String userId) {
        EnsureUtil.ensureNotNull("user id", (Object)userId);
        this.userId = userId;
        return this;
    }

    @Override
    public TenantQuery groupMember(String groupId) {
        EnsureUtil.ensureNotNull("group id", (Object)groupId);
        this.groupId = groupId;
        return this;
    }

    @Override
    public TenantQuery includingGroupsOfUser(boolean includingGroups) {
        this.includingGroups = includingGroups;
        return this;
    }

    @Override
    public TenantQuery orderByTenantId() {
        return (TenantQuery)this.orderBy(TenantQueryProperty.GROUP_ID);
    }

    @Override
    public TenantQuery orderByTenantName() {
        return (TenantQuery)this.orderBy(TenantQueryProperty.NAME);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isIncludingGroups() {
        return this.includingGroups;
    }
}

