/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.AbstractVariableQueryImpl;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.VariableInstanceQueryProperty;
import org.eximeebpms.bpm.engine.impl.cmd.CommandLogger;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.eximeebpms.bpm.engine.impl.util.CompareUtil;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;

public class VariableInstanceQueryImpl
extends AbstractVariableQueryImpl<VariableInstanceQuery, VariableInstance>
implements VariableInstanceQuery,
Serializable {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    private static final long serialVersionUID = 1L;
    protected String variableId;
    protected String variableName;
    protected String[] variableNames;
    protected String variableNameLike;
    protected String[] executionIds;
    protected String[] processInstanceIds;
    protected String[] caseExecutionIds;
    protected String[] caseInstanceIds;
    protected String[] taskIds;
    protected String[] batchIds;
    protected String[] variableScopeIds;
    protected String[] activityInstanceIds;
    protected String[] tenantIds;
    protected boolean isByteArrayFetchingEnabled = true;
    protected boolean isCustomObjectDeserializationEnabled = true;

    public VariableInstanceQueryImpl() {
    }

    public VariableInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public VariableInstanceQuery variableId(String id) {
        EnsureUtil.ensureNotNull("id", (Object)id);
        this.variableId = id;
        return this;
    }

    @Override
    public VariableInstanceQuery variableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    @Override
    public VariableInstanceQuery variableNameIn(String ... variableNames) {
        this.variableNames = variableNames;
        return this;
    }

    @Override
    public VariableInstanceQuery variableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
        return this;
    }

    @Override
    public VariableInstanceQuery executionIdIn(String ... executionIds) {
        this.executionIds = executionIds;
        return this;
    }

    @Override
    public VariableInstanceQuery processInstanceIdIn(String ... processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public VariableInstanceQuery caseExecutionIdIn(String ... caseExecutionIds) {
        this.caseExecutionIds = caseExecutionIds;
        return this;
    }

    @Override
    public VariableInstanceQuery caseInstanceIdIn(String ... caseInstanceIds) {
        this.caseInstanceIds = caseInstanceIds;
        return this;
    }

    @Override
    public VariableInstanceQuery taskIdIn(String ... taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public VariableInstanceQuery batchIdIn(String ... batchIds) {
        this.batchIds = batchIds;
        return this;
    }

    @Override
    public VariableInstanceQuery variableScopeIdIn(String ... variableScopeIds) {
        this.variableScopeIds = variableScopeIds;
        return this;
    }

    @Override
    public VariableInstanceQuery activityInstanceIdIn(String ... activityInstanceIds) {
        this.activityInstanceIds = activityInstanceIds;
        return this;
    }

    @Override
    public VariableInstanceQuery disableBinaryFetching() {
        this.isByteArrayFetchingEnabled = false;
        return this;
    }

    @Override
    public VariableInstanceQuery disableCustomObjectDeserialization() {
        this.isCustomObjectDeserializationEnabled = false;
        return this;
    }

    @Override
    public VariableInstanceQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public VariableInstanceQuery orderByVariableName() {
        this.orderBy(VariableInstanceQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public VariableInstanceQuery orderByVariableType() {
        this.orderBy(VariableInstanceQueryProperty.VARIABLE_TYPE);
        return this;
    }

    @Override
    public VariableInstanceQuery orderByActivityInstanceId() {
        this.orderBy(VariableInstanceQueryProperty.ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public VariableInstanceQuery orderByTenantId() {
        this.orderBy(VariableInstanceQueryProperty.TENANT_ID);
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.elementIsNotContainedInArray(this.variableName, this.variableNames);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getVariableInstanceManager().findVariableInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<VariableInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        List<VariableInstance> result = commandContext.getVariableInstanceManager().findVariableInstanceByQueryCriteria(this, page);
        if (result == null) {
            return result;
        }
        for (VariableInstance variableInstance : result) {
            VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
            if (!this.shouldFetchValue(variableInstanceEntity)) continue;
            try {
                variableInstanceEntity.getTypedValue(this.isCustomObjectDeserializationEnabled);
            }
            catch (Exception t) {
                LOG.exceptionWhileGettingValueForVariable(t);
            }
        }
        return result;
    }

    protected boolean shouldFetchValue(VariableInstanceEntity entity) {
        return this.isByteArrayFetchingEnabled || !AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(entity.getSerializer().getType().getName());
    }

    public String getVariableId() {
        return this.variableId;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String[] getVariableNames() {
        return this.variableNames;
    }

    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public String[] getExecutionIds() {
        return this.executionIds;
    }

    public String[] getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String[] getCaseExecutionIds() {
        return this.caseExecutionIds;
    }

    public String[] getCaseInstanceIds() {
        return this.caseInstanceIds;
    }

    public String[] getTaskIds() {
        return this.taskIds;
    }

    public String[] getBatchIds() {
        return this.batchIds;
    }

    public String[] getVariableScopeIds() {
        return this.variableScopeIds;
    }

    public String[] getActivityInstanceIds() {
        return this.activityInstanceIds;
    }
}

