/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.batch;

import eximeebpms.impl.com.google.gson.JsonObject;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.impl.batch.AbstractBatchConfigurationObjectConverter;
import org.eximeebpms.bpm.engine.impl.batch.BatchConfiguration;
import org.eximeebpms.bpm.engine.impl.batch.BatchEntity;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobConfiguration;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobContext;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobHandler;
import org.eximeebpms.bpm.engine.impl.batch.DeploymentMapping;
import org.eximeebpms.bpm.engine.impl.batch.DeploymentMappings;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.OptimisticLockingResult;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.JsonUtil;

public abstract class AbstractBatchJobHandler<T extends BatchConfiguration>
implements BatchJobHandler<T>,
OptimisticLockingListener {
    @Override
    public abstract JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration();

    @Override
    public boolean createJobs(BatchEntity batch) {
        Object configuration = this.readConfiguration(batch.getConfigurationBytes());
        String deploymentId = null;
        DeploymentMappings idMappings = ((BatchConfiguration)configuration).getIdMappings();
        boolean deploymentAware = idMappings != null && !idMappings.isEmpty();
        List<String> ids = ((BatchConfiguration)configuration).getIds();
        if (deploymentAware) {
            this.sanitizeMappings(idMappings, ids);
            DeploymentMapping mappingToProcess = (DeploymentMapping)idMappings.get(0);
            ids = mappingToProcess.getIds(ids);
            deploymentId = mappingToProcess.getDeploymentId();
        }
        int batchJobsPerSeed = batch.getBatchJobsPerSeed();
        int invocationsPerBatchJob = batch.getInvocationsPerBatchJob();
        int numberOfItemsToProcess = Math.min(invocationsPerBatchJob * batchJobsPerSeed, ids.size());
        List<String> processIds = ids.subList(0, numberOfItemsToProcess);
        this.createJobEntities(batch, configuration, deploymentId, processIds, invocationsPerBatchJob);
        if (deploymentAware) {
            if (ids.isEmpty()) {
                idMappings.remove(0);
            } else {
                ((DeploymentMapping)idMappings.get(0)).removeIds(numberOfItemsToProcess);
            }
        }
        batch.setConfigurationBytes(this.writeConfiguration((T)configuration));
        return deploymentAware ? idMappings.isEmpty() : ids.isEmpty();
    }

    @Override
    public final void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String byteArrayId = configuration.getConfigurationByteArrayId();
        ByteArrayEntity byteArray = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, byteArrayId);
        byte[] configurationByteArray = byteArray.getBytes();
        Object batchConfiguration = this.readConfiguration(configurationByteArray);
        String batchId = ((BatchConfiguration)batchConfiguration).getBatchId();
        BatchEntity batch = commandContext.getBatchManager().findBatchById(batchId);
        if (batch != null && batch.getExecutionStartTime() == null) {
            commandContext.getDbEntityManager().registerOptimisticLockingListener(this);
            Date executionStartTime = ClockUtil.now();
            batch.setExecutionStartTime(executionStartTime);
            batch.fireHistoricUpdateEvent();
        }
        this.executeHandler(batchConfiguration, execution, commandContext, tenantId);
    }

    protected abstract void executeHandler(T var1, ExecutionEntity var2, CommandContext var3, String var4);

    protected void sanitizeMappings(DeploymentMappings idMappings, List<String> ids) {
        int elementsToRemove = idMappings.getOverallIdCount() - ids.size();
        if (elementsToRemove > 0) {
            Iterator iterator = idMappings.iterator();
            while (iterator.hasNext()) {
                DeploymentMapping deploymentMapping = (DeploymentMapping)iterator.next();
                if (deploymentMapping.getCount() <= elementsToRemove) {
                    iterator.remove();
                    if ((elementsToRemove -= deploymentMapping.getCount()) != 0) continue;
                    break;
                }
                deploymentMapping.removeIds(elementsToRemove);
                break;
            }
        }
    }

    protected void createJobEntities(BatchEntity batch, T configuration, String deploymentId, List<String> processIds, int invocationsPerBatchJob) {
        if (processIds == null || processIds.isEmpty()) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        ByteArrayManager byteArrayManager = commandContext.getByteArrayManager();
        JobManager jobManager = commandContext.getJobManager();
        int createdJobs = 0;
        while (!processIds.isEmpty()) {
            int lastIdIndex = Math.min(invocationsPerBatchJob, processIds.size());
            List<String> idsForJob = processIds.subList(0, lastIdIndex);
            T jobConfiguration = this.createJobConfiguration(configuration, idsForJob);
            ((BatchConfiguration)jobConfiguration).setBatchId(batch.getId());
            ByteArrayEntity configurationEntity = this.saveConfiguration(byteArrayManager, jobConfiguration);
            JobEntity job = this.createBatchJob(batch, configurationEntity);
            job.setDeploymentId(deploymentId);
            this.postProcessJob(configuration, job, jobConfiguration);
            jobManager.insertAndHintJobExecutor(job);
            idsForJob.clear();
            ++createdJobs;
        }
        batch.setJobsCreated(batch.getJobsCreated() + createdJobs);
    }

    protected abstract T createJobConfiguration(T var1, List<String> var2);

    protected void postProcessJob(T configuration, JobEntity job, T jobConfiguration) {
    }

    protected JobEntity createBatchJob(BatchEntity batch, ByteArrayEntity configuration) {
        BatchJobContext creationContext = new BatchJobContext(batch, configuration);
        return this.getJobDeclaration().createJobInstance(creationContext);
    }

    @Override
    public void deleteJobs(BatchEntity batch) {
        List<JobEntity> jobs = Context.getCommandContext().getJobManager().findJobsByJobDefinitionId(batch.getBatchJobDefinitionId());
        for (JobEntity job : jobs) {
            job.delete();
        }
    }

    @Override
    public BatchJobConfiguration newConfiguration(String canonicalString) {
        return new BatchJobConfiguration(canonicalString);
    }

    @Override
    public void onDelete(BatchJobConfiguration configuration, JobEntity jobEntity) {
        String byteArrayId = configuration.getConfigurationByteArrayId();
        if (byteArrayId != null) {
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(byteArrayId);
        }
    }

    protected ByteArrayEntity saveConfiguration(ByteArrayManager byteArrayManager, T jobConfiguration) {
        ByteArrayEntity configurationEntity = new ByteArrayEntity();
        configurationEntity.setBytes(this.writeConfiguration(jobConfiguration));
        byteArrayManager.insert(configurationEntity);
        return configurationEntity;
    }

    @Override
    public byte[] writeConfiguration(T configuration) {
        JsonObject jsonObject = this.getJsonConverterInstance().toJsonObject(configuration);
        return JsonUtil.asBytes(jsonObject);
    }

    @Override
    public T readConfiguration(byte[] serializedConfiguration) {
        return (T)this.getJsonConverterInstance().toObject(JsonUtil.asObject(serializedConfiguration));
    }

    protected abstract AbstractBatchConfigurationObjectConverter<T> getJsonConverterInstance();

    @Override
    public Class<? extends DbEntity> getEntityType() {
        return BatchEntity.class;
    }

    @Override
    public OptimisticLockingResult failedOperation(DbOperation operation) {
        if (operation instanceof DbEntityOperation) {
            return OptimisticLockingResult.IGNORE;
        }
        return OptimisticLockingResult.THROW;
    }

    @Override
    public int calculateInvocationsPerBatchJob(String batchType, T configuration) {
        ProcessEngineConfigurationImpl engineConfig = Context.getProcessEngineConfiguration();
        Map<String, Integer> invocationsPerBatchJobByBatchType = engineConfig.getInvocationsPerBatchJobByBatchType();
        Integer invocationCount = invocationsPerBatchJobByBatchType.get(batchType);
        if (invocationCount != null) {
            return invocationCount;
        }
        return engineConfig.getInvocationsPerBatchJob();
    }
}

